/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.selection.base.AbstractMultipleSelectionModel;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.property.MapProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;

public class MultipleSelectionManager<T> {
    private final AbstractMultipleSelectionModel<T> selectionModel;
    private final MapProperty<Integer, T> selection = new SimpleMapProperty(this.getMap());
    private boolean allowsMultipleSelection = true;

    public MultipleSelectionManager(AbstractMultipleSelectionModel<T> selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void clearSelection() {
        this.selection.set(this.getMap());
    }

    public void deselectIndex(int index) {
        this.selection.remove((Object)index);
    }

    public void deselectItem(T item) {
        int index = this.selectionModel.getItems().indexOf(item);
        if (index >= 0) {
            this.selection.remove((Object)index);
        }
    }

    public void deselectIndexes(int ... indexes) {
        ObservableMap<Integer, T> tmp = this.getMap((Map<Integer, T>)this.selection);
        for (int index : indexes) {
            tmp.remove((Object)index);
        }
        this.selection.set(tmp);
    }

    public void deselectItems(T ... items) {
        Map<Integer, Object> tmp = Arrays.stream(items).filter(item -> this.selectionModel.getItems().contains(item)).collect(Collectors.toMap(item -> this.selectionModel.getItems().indexOf(item), item -> item));
        ObservableMap<Integer, Object> newSelection = this.getMap(tmp);
        this.selection.set(newSelection);
    }

    public void updateSelection(int index) {
        Object item = this.selectionModel.getItems().get(index);
        if (this.allowsMultipleSelection) {
            this.selection.put((Object)index, item);
        } else {
            ObservableMap<Integer, T> map = this.getMap();
            map.put((Object)index, item);
            this.selection.set(map);
        }
    }

    public void updateSelection(T item) {
        int index = this.selectionModel.getItems().indexOf(item);
        if (this.allowsMultipleSelection) {
            this.selection.put((Object)index, item);
        } else {
            ObservableMap<Integer, T> map = this.getMap();
            map.put((Object)index, item);
            this.selection.set(map);
        }
    }

    public void updateSelectionByIndexes(List<Integer> indexes) {
        if (indexes.isEmpty()) {
            return;
        }
        if (this.allowsMultipleSelection) {
            LinkedHashSet<Integer> indexesSet = new LinkedHashSet<Integer>(indexes);
            Map newSelection = indexesSet.stream().collect(Collectors.toMap(i -> i, i -> this.selectionModel.getItems().get(i.intValue()), (t, t2) -> t2, LinkedHashMap::new));
            this.selection.putAll(newSelection);
        } else {
            int index = indexes.get(0);
            Object item = this.selectionModel.getItems().get(index);
            ObservableMap<Integer, T> map = this.getMap();
            map.put((Object)index, item);
            this.selection.set(map);
        }
    }

    public void updateSelectionByItems(List<T> items) {
        if (items.isEmpty()) {
            return;
        }
        if (this.allowsMultipleSelection) {
            Set indexesSet = items.stream().mapToInt(item -> this.selectionModel.getItems().indexOf(item)).boxed().collect(Collectors.toSet());
            Map<Integer, Object> newSelection = indexesSet.stream().collect(Collectors.toMap(i -> i, items::get));
            this.selection.putAll(newSelection);
        } else {
            T item2 = items.get(0);
            int index = this.selectionModel.getItems().indexOf(item2);
            ObservableMap<Integer, T> map = this.getMap();
            map.put((Object)index, item2);
            this.selection.set(map);
        }
    }

    public void expandSelection(int index) {
        if (this.selection.isEmpty()) {
            this.replaceSelection(NumberRange.expandRangeToArray(0, index));
            return;
        }
        int min = this.selection.keySet().stream().min(Integer::compareTo).orElse(-1);
        if (index == min) {
            this.replaceSelection(index);
            return;
        }
        if (index < min) {
            this.replaceSelection(NumberRange.expandRangeToArray(index, min));
        } else {
            this.replaceSelection(NumberRange.expandRangeToArray(min, index));
        }
    }

    public void replaceSelection(Integer ... indexes) {
        ObservableMap<Integer, T> newSelection = this.getMap();
        if (this.allowsMultipleSelection) {
            newSelection.putAll(Arrays.stream(indexes).collect(Collectors.toMap(i -> i, i -> this.selectionModel.getItems().get(i.intValue()))));
        } else {
            int index = indexes[0];
            newSelection.put((Object)index, this.selectionModel.getItems().get(index));
        }
        this.selection.set(newSelection);
    }

    public void replaceSelection(T ... items) {
        ObservableMap<Integer, T> newSelection = this.getMap();
        if (this.allowsMultipleSelection) {
            newSelection.putAll(Arrays.stream(items).collect(Collectors.toMap(item -> this.selectionModel.getItems().indexOf(item), item -> item)));
        } else {
            T item2 = items[0];
            newSelection.put((Object)this.selectionModel.getItems().indexOf(item2), item2);
        }
        this.selection.set(newSelection);
    }

    protected ObservableMap<Integer, T> getMap() {
        return FXCollections.observableMap(new LinkedHashMap());
    }

    protected ObservableMap<Integer, T> getMap(Map<Integer, T> map) {
        return FXCollections.observableMap(new LinkedHashMap<Integer, T>(map));
    }

    public ObservableMap<Integer, T> getSelection() {
        return (ObservableMap)this.selection.get();
    }

    public MapProperty<Integer, T> selectionProperty() {
        return this.selection;
    }

    public void setSelection(ObservableMap<Integer, T> selection) {
        this.selection.set(selection);
    }

    public List<T> getSelectedValues() {
        return List.copyOf(this.selection.values());
    }

    public boolean allowsMultipleSelection() {
        return this.allowsMultipleSelection;
    }

    public void setAllowsMultipleSelection(boolean allowsMultipleSelection) {
        if (!allowsMultipleSelection) {
            this.clearSelection();
        }
        this.allowsMultipleSelection = allowsMultipleSelection;
    }
}

