/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import io.github.palexdev.materialfx.beans.AnimationsData;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javafx.util.Duration;

public class AnimationUtils {
    private AnimationUtils() {
    }

    public static void disableTemporarily(Duration duration, Node node) {
        node.setDisable(true);
        PauseBuilder.build().setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> node.setDisable(false))).setDuration(duration).getAnimation().play();
    }

    public static void disableTemporarily(double millis, Node node) {
        AnimationUtils.disableTemporarily(Duration.millis((double)millis), node);
    }

    public static void executeLater(Duration duration, EventHandler<ActionEvent> onFinished) {
        PauseBuilder.build().setDuration(duration).setOnFinished(onFinished).getAnimation().play();
    }

    public static void executeLater(double millis, EventHandler<ActionEvent> onFinished) {
        AnimationUtils.executeLater(Duration.millis((double)millis), onFinished);
    }

    public static AbstractBuilder transitionText(Labeled labeled, Duration duration, String nexText) {
        return SequentialBuilder.build().hide(AnimationsData.of((Node)labeled, duration, (EventHandler<ActionEvent>)((EventHandler)event -> labeled.setText(nexText)))).show(AnimationsData.of((Node)labeled, duration));
    }

    public static AbstractBuilder transitionText(Labeled labeled, double millis, String nexText) {
        return AnimationUtils.transitionText(labeled, Duration.millis((double)millis), nexText);
    }

    public static AbstractBuilder transitionText(Text text, Duration duration, String nexText) {
        return SequentialBuilder.build().hide(AnimationsData.of((Node)text, duration, (EventHandler<ActionEvent>)((EventHandler)event -> text.setText(nexText)))).show(AnimationsData.of((Node)text, duration));
    }

    public static AbstractBuilder transitionText(Text text, double millis, String nexText) {
        return AnimationUtils.transitionText(text, Duration.millis((double)millis), nexText);
    }

    public static boolean isPlaying(Animation animation) {
        return animation.getStatus() == Animation.Status.RUNNING;
    }

    public static boolean isPaused(Animation animation) {
        return animation.getStatus() == Animation.Status.PAUSED;
    }

    public static boolean isStopped(Animation animation) {
        return animation.getStatus() == Animation.Status.STOPPED;
    }

    public static class PauseBuilder {
        private final PauseTransition pauseTransition = new PauseTransition();

        public static PauseBuilder build() {
            return new PauseBuilder();
        }

        public PauseBuilder setDelay(Duration duration) {
            this.pauseTransition.setDelay(duration);
            return this;
        }

        public PauseBuilder setDelay(double millis) {
            this.pauseTransition.setDelay(Duration.millis((double)millis));
            return this;
        }

        public PauseBuilder setDuration(Duration duration) {
            this.pauseTransition.setDuration(duration);
            return this;
        }

        public PauseBuilder setDuration(double millis) {
            this.pauseTransition.setDuration(Duration.millis((double)millis));
            return this;
        }

        public PauseBuilder setOnFinished(EventHandler<ActionEvent> onFinished) {
            this.pauseTransition.setOnFinished(onFinished);
            return this;
        }

        public PauseTransition getAnimation() {
            return this.pauseTransition;
        }

        public void runWhile(BooleanExpression booleanExpression, Runnable retryAction, Runnable onSuccessAction) {
            this.setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                if (!booleanExpression.get()) {
                    retryAction.run();
                    this.getAnimation().playFromStart();
                } else {
                    onSuccessAction.run();
                }
            }));
            this.getAnimation().play();
        }

        public void runWhile(BooleanExpression booleanExpression, Runnable retryAction, Runnable onSuccessAction, int maxRetryCount) {
            AtomicInteger retryCount = new AtomicInteger(0);
            this.setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                if (!booleanExpression.get() && retryCount.get() < maxRetryCount) {
                    retryCount.getAndIncrement();
                    retryAction.run();
                    this.getAnimation().playFromStart();
                } else {
                    onSuccessAction.run();
                }
            }));
            this.getAnimation().play();
        }
    }

    public static class SequentialBuilder
    extends AbstractBuilder {
        private final SequentialTransition sequentialTransition = new SequentialTransition();

        public SequentialBuilder() {
            this.init((Animation)this.sequentialTransition);
        }

        public static SequentialBuilder build() {
            return new SequentialBuilder();
        }

        @Override
        protected void addAnimation(Animation animation) {
            this.sequentialTransition.getChildren().add((Object)animation);
        }

        public SequentialTransition getAnimation() {
            return this.sequentialTransition;
        }
    }

    public static abstract class AbstractBuilder {
        protected Animation animation;

        protected abstract void addAnimation(Animation var1);

        public abstract Animation getAnimation();

        protected void init(Animation animation) {
            this.animation = animation;
        }

        public AbstractBuilder add(Animation animation) {
            this.addAnimation(animation);
            return this;
        }

        public AbstractBuilder add(Animation animation, EventHandler<ActionEvent> onFinished) {
            animation.setOnFinished(onFinished);
            this.addAnimation(animation);
            return this;
        }

        public AbstractBuilder add(Supplier<Animation> animationSupplier) {
            this.addAnimation(animationSupplier.get());
            return this;
        }

        public AbstractBuilder add(Supplier<Animation> animationSupplier, EventHandler<ActionEvent> onFinished) {
            Animation animation = animationSupplier.get();
            animation.setOnFinished(onFinished);
            this.addAnimation(animation);
            return this;
        }

        public AbstractBuilder add(KeyFrame ... keyFrames) {
            this.addAnimation((Animation)new Timeline(keyFrames));
            return this;
        }

        public AbstractBuilder add(EventHandler<ActionEvent> onFinished, KeyFrame ... keyFrames) {
            this.addAnimation((Animation)TimelineBuilder.build().add(keyFrames).setOnFinished(onFinished).getAnimation());
            return this;
        }

        public AbstractBuilder disable(Duration duration, Node ... nodes) {
            for (Node node : nodes) {
                this.addAnimation((Animation)PauseBuilder.build().setDuration(duration).setOnFinished((EventHandler<ActionEvent>)((EventHandler)end -> node.setDisable(true))).getAnimation());
            }
            return this;
        }

        public AbstractBuilder enable(Duration duration, Node ... nodes) {
            for (Node node : nodes) {
                this.addAnimation((Animation)PauseBuilder.build().setDuration(duration).setOnFinished((EventHandler<ActionEvent>)((EventHandler)end -> node.setDisable(false))).getAnimation());
            }
            return this;
        }

        public AbstractBuilder hide(Duration duration, Window ... windows) {
            for (Window window : windows) {
                this.addAnimation((Animation)TimelineBuilder.build().add(KeyFrames.of(duration, window.opacityProperty(), Integer.valueOf(0))).getAnimation());
            }
            return this;
        }

        public AbstractBuilder hide(double millis, Window ... windows) {
            return this.hide(Duration.millis((double)millis), windows);
        }

        public AbstractBuilder hide(Duration duration, Node ... nodes) {
            for (Node node : nodes) {
                this.addAnimation((Animation)TimelineBuilder.build().hide(duration, node).getAnimation());
            }
            return this;
        }

        public AbstractBuilder hide(double millis, Node ... nodes) {
            return this.hide(Duration.millis((double)millis), nodes);
        }

        public final AbstractBuilder hide(AnimationsData ... data) {
            for (AnimationsData animData : data) {
                this.addAnimation((Animation)TimelineBuilder.build().hide(animData).getAnimation());
            }
            return this;
        }

        public AbstractBuilder show(Duration duration, Window ... windows) {
            for (Window window : windows) {
                this.addAnimation((Animation)TimelineBuilder.build().show(duration, window).getAnimation());
            }
            return this;
        }

        public AbstractBuilder show(double millis, Window ... windows) {
            return this.show(Duration.millis((double)millis), windows);
        }

        public AbstractBuilder show(Duration duration, Node ... nodes) {
            for (Node node : nodes) {
                this.addAnimation((Animation)TimelineBuilder.build().show(duration, node).getAnimation());
            }
            return this;
        }

        public AbstractBuilder show(double millis, Node ... nodes) {
            return this.show(Duration.millis((double)millis), nodes);
        }

        public final AbstractBuilder show(AnimationsData ... data) {
            for (AnimationsData animData : data) {
                this.addAnimation((Animation)TimelineBuilder.build().show(animData).getAnimation());
            }
            return this;
        }

        public AbstractBuilder setOnFinished(EventHandler<ActionEvent> onFinished) {
            this.animation.setOnFinished(onFinished);
            return this;
        }

        public AbstractBuilder setCycleCount(int cycleCount) {
            this.animation.setCycleCount(cycleCount);
            return this;
        }

        public AbstractBuilder setDelay(Duration delay) {
            this.animation.setDelay(delay);
            return this;
        }

        public AbstractBuilder setDelay(double millis) {
            this.animation.setDelay(Duration.millis((double)millis));
            return this;
        }

        public AbstractBuilder setRate(double rate) {
            this.animation.setRate(rate);
            return this;
        }
    }

    public static class KeyFrames {
        private KeyFrames() {
        }

        public static KeyFrame of(Duration duration, EventHandler<ActionEvent> action) {
            return new KeyFrame(duration, action, new KeyValue[0]);
        }

        public static KeyFrame of(double millis, EventHandler<ActionEvent> action) {
            return KeyFrames.of(Duration.millis((double)millis), action);
        }

        public static KeyFrame of(Duration duration, KeyValue ... keyValues) {
            return new KeyFrame(duration, keyValues);
        }

        public static KeyFrame of(double millis, KeyValue ... keyValues) {
            return KeyFrames.of(Duration.millis((double)millis), keyValues);
        }

        public static <T> KeyFrame of(Duration duration, WritableValue<T> writableValue, T endValue) {
            return KeyFrames.of(duration, new KeyValue(writableValue, endValue));
        }

        public static <T> KeyFrame of(double millis, WritableValue<T> writableValue, T endValue) {
            return KeyFrames.of(Duration.millis((double)millis), writableValue, endValue);
        }

        public static <T> KeyFrame of(Duration duration, WritableValue<T> writableValue, T endValue, Interpolator interpolator) {
            return KeyFrames.of(duration, new KeyValue(writableValue, endValue, interpolator));
        }

        public static <T> KeyFrame of(double millis, WritableValue<T> writableValue, T endValue, Interpolator interpolator) {
            return KeyFrames.of(Duration.millis((double)millis), writableValue, endValue, interpolator);
        }

        public static <T> KeyFrame of(Duration duration, WritableValue<T> writableValue, T endValue, Interpolators interpolator) {
            return KeyFrames.of(duration, new KeyValue(writableValue, endValue, interpolator.toInterpolator()));
        }

        public static <T> KeyFrame of(double millis, WritableValue<T> writableValue, T endValue, Interpolators interpolator) {
            return KeyFrames.of(Duration.millis((double)millis), writableValue, endValue, interpolator.toInterpolator());
        }
    }

    public static class TimelineBuilder {
        private final Timeline timeline = new Timeline();

        public static TimelineBuilder build() {
            return new TimelineBuilder();
        }

        public TimelineBuilder add(KeyFrame ... keyFrames) {
            this.timeline.getKeyFrames().addAll(Arrays.asList(keyFrames));
            return this;
        }

        public TimelineBuilder hide(Duration duration, Window window) {
            this.add(KeyFrames.of(duration, window.opacityProperty(), Integer.valueOf(0)));
            return this;
        }

        public TimelineBuilder hide(double millis, Window window) {
            return this.hide(Duration.millis((double)millis), window);
        }

        public TimelineBuilder hide(Duration duration, Node node) {
            this.add(KeyFrames.of(Duration.ZERO, node.opacityProperty(), Double.valueOf(1.0), MFXAnimationFactory.INTERPOLATOR_V1), KeyFrames.of(duration, node.opacityProperty(), Integer.valueOf(0), MFXAnimationFactory.INTERPOLATOR_V1));
            return this;
        }

        public TimelineBuilder hide(double millis, Node node) {
            return this.hide(Duration.millis((double)millis), node);
        }

        public final TimelineBuilder hide(AnimationsData data) {
            this.add(KeyFrames.of(Duration.ZERO, data.node().opacityProperty(), Double.valueOf(1.0)), KeyFrames.of(data.duration(), data.node().opacityProperty(), Double.valueOf(0.0)));
            this.setOnFinished(data.onFinished());
            return this;
        }

        public TimelineBuilder show(Duration duration, Window window) {
            this.add(KeyFrames.of(duration, window.opacityProperty(), Double.valueOf(1.0)));
            return this;
        }

        public TimelineBuilder show(double millis, Window window) {
            return this.show(Duration.millis((double)millis), window);
        }

        public TimelineBuilder show(Duration duration, Node node) {
            this.add(KeyFrames.of(Duration.ZERO, node.opacityProperty(), Double.valueOf(0.0)), KeyFrames.of(duration, node.opacityProperty(), Double.valueOf(1.0)));
            return this;
        }

        public TimelineBuilder show(double millis, Node node) {
            return this.show(Duration.millis((double)millis), node);
        }

        public final TimelineBuilder show(AnimationsData data) {
            this.add(KeyFrames.of(Duration.ZERO, data.node().opacityProperty(), Double.valueOf(0.0)), KeyFrames.of(data.duration(), data.node().opacityProperty(), Double.valueOf(1.0)));
            this.setOnFinished(data.onFinished());
            return this;
        }

        public TimelineBuilder setCycleCount(int cycleCount) {
            this.timeline.setCycleCount(cycleCount);
            return this;
        }

        public TimelineBuilder setDelay(Duration delay) {
            this.timeline.setDelay(delay);
            return this;
        }

        public TimelineBuilder setDelay(double millis) {
            this.timeline.setDelay(Duration.millis((double)millis));
            return this;
        }

        public TimelineBuilder setRate(double rate) {
            this.timeline.setRate(rate);
            return this;
        }

        public TimelineBuilder setOnFinished(EventHandler<ActionEvent> onFinished) {
            this.timeline.setOnFinished(onFinished);
            return this;
        }

        public Timeline getAnimation() {
            return this.timeline;
        }
    }

    public static class ParallelBuilder
    extends AbstractBuilder {
        private final ParallelTransition parallelTransition = new ParallelTransition();

        public ParallelBuilder() {
            this.init((Animation)this.parallelTransition);
        }

        public static ParallelBuilder build() {
            return new ParallelBuilder();
        }

        @Override
        protected void addAnimation(Animation animation) {
            this.parallelTransition.getChildren().add((Object)animation);
        }

        public ParallelTransition getAnimation() {
            return this.parallelTransition;
        }
    }
}

