/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;

public class NumberRange<T extends Number> {
    private final T min;
    private final T max;

    public NumberRange(T min, T max) {
        this.min = min;
        this.max = max;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberRange that = (NumberRange)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return "Min[" + String.valueOf(this.min) + "], Max[" + String.valueOf(this.max) + "]";
    }

    public static <T extends Number> NumberRange<T> of(T min, T max) {
        return new NumberRange<T>(min, max);
    }

    public static <T extends Number> NumberRange<T> of(T val) {
        return new NumberRange<T>(val, val);
    }

    public static boolean inRangeOf(double val, NumberRange<Double> range) {
        return Math.max(range.getMin(), val) == Math.min(val, range.getMax());
    }

    public static boolean inRangeOf(float val, NumberRange<Float> range) {
        return Math.max(range.getMin().floatValue(), val) == Math.min(val, range.getMax().floatValue());
    }

    public static boolean inRangeOf(int val, NumberRange<Integer> range) {
        return Math.max(range.getMin(), val) == Math.min(val, range.getMax());
    }

    public static boolean inRangeOf(long val, NumberRange<Long> range) {
        return Math.max(range.getMin(), val) == Math.min(val, range.getMax());
    }

    public static boolean inRangeOf(double val, List<NumberRange<Double>> ranges) {
        return ranges.stream().anyMatch(range -> NumberRange.inRangeOf(val, range));
    }

    public static boolean inRangeOf(float val, List<NumberRange<Float>> ranges) {
        return ranges.stream().anyMatch(range -> NumberRange.inRangeOf(val, range));
    }

    public static boolean inRangeOf(int val, List<NumberRange<Integer>> ranges) {
        return ranges.stream().anyMatch(range -> NumberRange.inRangeOf(val, range));
    }

    public static boolean inRangeOf(long val, List<NumberRange<Long>> ranges) {
        return ranges.stream().anyMatch(range -> NumberRange.inRangeOf(val, range));
    }

    public static List<Integer> expandRange(NumberRange<Integer> range) {
        return IntStream.rangeClosed(range.getMin(), range.getMax()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static List<Integer> expandRange(int min, int max) {
        return IntStream.rangeClosed(min, max).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static Set<Integer> expandRangeToSet(NumberRange<Integer> range) {
        return IntStream.rangeClosed(range.getMin(), range.getMax()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public static Set<Integer> expandRangeToSet(int min, int max) {
        return IntStream.rangeClosed(min, max).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public static Integer[] expandRangeToArray(int min, int max) {
        return (Integer[])IntStream.rangeClosed(min, max).boxed().toArray(Integer[]::new);
    }
}

