/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class ResettableBooleanProperty
extends SimpleBooleanProperty
implements ResettableProperty<Boolean> {
    private boolean defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableBooleanProperty() {
    }

    public ResettableBooleanProperty(boolean initialValue) {
        super(initialValue);
    }

    public ResettableBooleanProperty(boolean initialValue, boolean defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableBooleanProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableBooleanProperty(Object bean, String name, boolean initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableBooleanProperty(Object bean, String name, boolean initialValue, boolean defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(boolean newValue) {
        this.hasBeenReset = newValue == this.defaultValue;
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue() == this.defaultValue && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Boolean defaultValue) {
        this.defaultValue = defaultValue;
    }
}

