/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleDoubleProperty;

public class ResettableDoubleProperty
extends SimpleDoubleProperty
implements ResettableProperty<Number> {
    private double defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableDoubleProperty() {
    }

    public ResettableDoubleProperty(double initialValue) {
        super(initialValue);
    }

    public ResettableDoubleProperty(double initialValue, double defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableDoubleProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableDoubleProperty(Object bean, String name, double initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableDoubleProperty(Object bean, String name, double initialValue, Double defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(double newValue) {
        this.hasBeenReset = newValue == this.defaultValue;
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue() == this.defaultValue && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public Double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue.doubleValue();
    }
}

