/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleFloatProperty;

public class ResettableFloatProperty
extends SimpleFloatProperty
implements ResettableProperty<Number> {
    private float defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableFloatProperty() {
    }

    public ResettableFloatProperty(float initialValue) {
        super(initialValue);
    }

    public ResettableFloatProperty(float initialValue, float defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableFloatProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableFloatProperty(Object bean, String name, float initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableFloatProperty(Object bean, String name, float initialValue, Float defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue.floatValue();
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(float newValue) {
        this.hasBeenReset = newValue == this.defaultValue;
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue().floatValue() == this.defaultValue && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue.floatValue();
    }
}

