/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.resettable;

import io.github.palexdev.materialfx.beans.properties.base.ResettableProperty;
import javafx.beans.property.SimpleLongProperty;

public class ResettableLongProperty
extends SimpleLongProperty
implements ResettableProperty<Number> {
    private long defaultValue;
    private boolean fireChangeOnReset = false;
    private boolean hasBeenReset = false;

    public ResettableLongProperty() {
    }

    public ResettableLongProperty(long initialValue) {
        super(initialValue);
    }

    public ResettableLongProperty(long initialValue, long defaultValue) {
        super(initialValue);
        this.defaultValue = defaultValue;
    }

    public ResettableLongProperty(Object bean, String name) {
        super(bean, name);
    }

    public ResettableLongProperty(Object bean, String name, long initialValue) {
        super(bean, name, initialValue);
    }

    public ResettableLongProperty(Object bean, String name, long initialValue, long defaultValue) {
        super(bean, name, initialValue);
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isFireChangeOnReset() {
        return this.fireChangeOnReset;
    }

    @Override
    public void setFireChangeOnReset(boolean fireChangeOnReset) {
        this.fireChangeOnReset = fireChangeOnReset;
    }

    public void set(long newValue) {
        this.hasBeenReset = newValue == this.defaultValue;
        super.set(newValue);
    }

    protected void fireValueChangedEvent() {
        if (this.getValue() == this.defaultValue && !this.fireChangeOnReset) {
            return;
        }
        super.fireValueChangedEvent();
    }

    @Override
    public boolean hasBeenReset() {
        return this.hasBeenReset;
    }

    @Override
    public Long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(Number defaultValue) {
        this.defaultValue = defaultValue.longValue();
    }
}

