/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BiBindingHelper;
import io.github.palexdev.materialfx.bindings.BiBindingManager;
import io.github.palexdev.materialfx.bindings.BindingsMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;

public class BiBindingBuilder<T> {
    private final ObservableValue<? extends T> target;
    private BiConsumer<T, T> targetUpdater;
    private final BindingsMap<ObservableValue<? extends T>, BiConsumer<T, T>> sources = new BindingsMap();
    private BiBindingHelper<T> bindingHelper;
    private boolean eagerEvaluation = true;
    private boolean override = false;

    public BiBindingBuilder(ObservableValue<? extends T> target) {
        this.target = target;
    }

    public BiBindingBuilder<T> with(BiConsumer<T, T> targetUpdater) {
        this.targetUpdater = targetUpdater;
        return this;
    }

    public BiBindingBuilder<T> withHelper(BiBindingHelper<T> bindingHelper) {
        this.bindingHelper = bindingHelper;
        return this;
    }

    public BiBindingBuilder<T> to(Property<T> source) {
        return this.to((ObservableValue<T>)source, (BiConsumer<T, T>)((BiConsumer<Object, Object>)(oldValue, newValue) -> source.setValue(newValue)));
    }

    public BiBindingBuilder<T> to(ObservableValue<T> source, BiConsumer<T, T> sourceUpdater) {
        this.sources.put(source, sourceUpdater);
        return this;
    }

    @SafeVarargs
    public final BiBindingBuilder<T> to(Map.Entry<ObservableValue<? extends T>, BiConsumer<T, T>> ... sources) {
        this.sources.putAll(sources);
        return this;
    }

    public BiBindingBuilder<T> lazy() {
        this.eagerEvaluation = false;
        return this;
    }

    public BiBindingBuilder<T> override(boolean override) {
        this.override = override;
        return this;
    }

    public ObservableValue<? extends T> target() {
        return this.target;
    }

    public BiConsumer<T, T> targetUpdater() {
        return this.targetUpdater;
    }

    public BindingsMap<ObservableValue<? extends T>, BiConsumer<T, T>> getSources() {
        return this.sources;
    }

    public boolean isEagerEvaluation() {
        return this.eagerEvaluation;
    }

    public BiBindingManager create() {
        return BiBindingManager.instance().apply(this, this.bindingHelper, this.override);
    }
}

