/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BiBindingBuilder;
import io.github.palexdev.materialfx.bindings.BiBindingHelper;
import io.github.palexdev.materialfx.bindings.BindingManager;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyFloatWrapper;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;

public class BiBindingManager {
    private static final BiBindingManager instance = new BiBindingManager();
    private final WeakHashMap<ObservableValue, BiBindingHelper> bindings = new WeakHashMap();

    public static BiBindingManager instance() {
        return instance;
    }

    private BiBindingManager() {
    }

    public <T> BiBindingBuilder<T> bindBidirectional(ObservableValue<? extends T> target) {
        return new BiBindingBuilder<T>(target);
    }

    public <T> BiBindingBuilder<T> bindBidirectional(Property<T> target) {
        return new BiBindingBuilder<Object>((ObservableValue<Object>)target).with((oldValue, newValue) -> target.setValue(newValue));
    }

    public <T> BiBindingManager apply(BiBindingBuilder<T> bindingBuilder, BiBindingHelper<T> bindingHelper, boolean override) {
        BiBindingHelper helper;
        ObservableValue<T> target = bindingBuilder.target();
        this.bindingCheck(target);
        if (this.bindings.containsKey(target)) {
            BiBindingHelper existing = this.bindings.get(target);
            if (bindingHelper != null && existing != bindingHelper) {
                helper = BiBindingHelper.newFor(existing, bindingHelper, override);
                helper.bind((ObservableValue)bindingBuilder.target());
            } else {
                helper = existing;
                helper.addSources(bindingBuilder.getSources());
            }
        } else {
            helper = Objects.requireNonNullElseGet(bindingHelper, BiBindingHelper::new);
            ((BiBindingHelper)((BiBindingHelper)helper.bind((ObservableValue)target)).with((BiConsumer)bindingBuilder.targetUpdater())).addSources(bindingBuilder.getSources());
        }
        if (bindingBuilder.isEagerEvaluation()) {
            helper.invalidate();
        }
        this.bindings.put(bindingBuilder.target(), helper);
        return this;
    }

    public <T> BiBindingManager unbind(ObservableValue<? extends T> target, ObservableValue<? extends T> source) {
        BiBindingHelper bindingHelper = this.bindings.get(target);
        if (bindingHelper != null) {
            bindingHelper.unbind(source);
            if (bindingHelper.size() == 0) {
                this.bindings.remove(target);
            }
        }
        return this;
    }

    public <T> BiBindingManager clear(ObservableValue<? extends T> target) {
        BiBindingHelper bindingHelper = this.bindings.get(target);
        if (bindingHelper != null) {
            bindingHelper.clear();
            this.bindings.remove(target);
        }
        return this;
    }

    public <T> BiBindingManager disposeFor(ObservableValue<? extends T> target) {
        BiBindingHelper bindingHelper = this.bindings.get(target);
        if (bindingHelper != null) {
            bindingHelper.dispose();
            this.bindings.remove(target);
        }
        return this;
    }

    public BiBindingManager dispose() {
        this.bindings.forEach((observable, helper) -> helper.dispose());
        this.bindings.clear();
        return this;
    }

    public BiBindingManager unbindReadOnly(ReadOnlyBooleanWrapper target, ObservableValue<? extends Boolean> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public BiBindingManager unbindReadOnly(ReadOnlyStringWrapper target, ObservableValue<? extends String> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public BiBindingManager unbindReadOnly(ReadOnlyIntegerWrapper target, ObservableValue<? extends Integer> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public BiBindingManager unbindReadOnly(ReadOnlyLongWrapper target, ObservableValue<? extends Long> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public BiBindingManager unbindReadOnly(ReadOnlyFloatWrapper target, ObservableValue<? extends Float> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public BiBindingManager unbindReadOnly(ReadOnlyDoubleWrapper target, ObservableValue<? extends Double> source) {
        return this.unbind((ObservableValue)target.getReadOnlyProperty(), (ObservableValue)source);
    }

    public <T> BiBindingManager unbindReadOnly(ReadOnlyObjectWrapper<T> target, ObservableValue<? extends T> source) {
        return this.unbind((ObservableValue<? extends T>)target.getReadOnlyProperty(), source);
    }

    public <T> boolean isBound(ObservableValue<? extends T> target) {
        return this.bindings.containsKey(target);
    }

    public int size() {
        return this.bindings.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private <T> void bindingCheck(ObservableValue<? extends T> target) {
        if (BindingManager.instance().isBound(target)) {
            BindingManager.instance().unbind(target);
        }
    }
}

