/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BindingHelper;
import io.github.palexdev.materialfx.bindings.BindingManager;
import java.util.function.BiConsumer;
import javafx.beans.value.ObservableValue;

public class BindingBuilder<T> {
    private final ObservableValue<? extends T> target;
    private ObservableValue<? extends T> source;
    private BiConsumer<T, T> updater;

    public BindingBuilder(ObservableValue<? extends T> target) {
        this.target = target;
    }

    public BindingBuilder<T> to(ObservableValue<? extends T> source) {
        this.source = source;
        return this;
    }

    public BindingBuilder<T> with(BiConsumer<T, T> updater) {
        this.updater = updater;
        return this;
    }

    public ObservableValue<? extends T> target() {
        return this.target;
    }

    public ObservableValue<? extends T> source() {
        return this.source;
    }

    public BiConsumer<T, T> targetUpdater() {
        return this.updater;
    }

    public BindingManager create() {
        BindingHelper bindingHelper = new BindingHelper();
        bindingHelper.with((BiConsumer)this.updater);
        return BindingManager.instance().apply(this, bindingHelper);
    }
}

