/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BindingManager;
import io.github.palexdev.materialfx.bindings.base.AbstractBindingHelper;
import java.util.function.BiConsumer;
import javafx.beans.value.ObservableValue;

public class BindingHelper<T>
extends AbstractBindingHelper<T> {
    private ObservableValue<? extends T> source;
    protected boolean ignoreBinding;

    @Override
    public BindingHelper<T> bind(ObservableValue<? extends T> target) {
        this.target = target;
        return this;
    }

    @Override
    public BindingHelper<T> with(BiConsumer<T, T> targetUpdater) {
        this.targetUpdater = targetUpdater;
        return this;
    }

    public BindingHelper<T> to(ObservableValue<? extends T> source) {
        this.source = source;
        this.beforeBind();
        source.addListener(this.sourceListener);
        this.afterBind();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateTarget(ObservableValue<? extends T> source, T oldValue, T newValue) {
        try {
            this.ignoreBinding = true;
            super.updateTarget(source, oldValue, newValue);
        }
        finally {
            this.ignoreBinding = false;
        }
    }

    @Override
    public void invalidate() {
        Object value = this.source.getValue();
        this.updateTarget(this.source, value, value);
    }

    public void unbind() {
        this.beforeUnbind();
        this.source.removeListener(this.sourceListener);
        this.source = null;
        this.afterUnbind();
    }

    @Override
    public void dispose() {
        this.unbind();
        this.target = null;
    }

    public boolean isBound() {
        return BindingManager.instance().isBound(this.target);
    }

    public boolean isIgnoreBinding() {
        return this.ignoreBinding;
    }

    @Override
    public boolean isDispose() {
        return this.target == null;
    }
}

