/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BindingsMap<K, V>
extends WeakHashMap<K, V> {
    private LinkedList<WeakReference<K>> orderedKeys = new LinkedList();

    public BindingsMap() {
    }

    public BindingsMap(Map<? extends K, ? extends V> m) {
        super(m);
    }

    public BindingsMap(int initialCapacity) {
        super(initialCapacity);
    }

    public BindingsMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    private void clearReferences() {
        this.orderedKeys.removeIf(reference -> reference != null && reference.get() == null);
        this.size();
    }

    @SafeVarargs
    private void updateKeysList(K ... keys) {
        LinkedHashSet uniqueKeys = this.orderedKeys.stream().map(Reference::get).collect(Collectors.toCollection(LinkedHashSet::new));
        uniqueKeys.addAll(Arrays.asList(keys));
        this.orderedKeys = uniqueKeys.stream().map(WeakReference::new).collect(Collectors.toCollection(LinkedList::new));
        this.clearReferences();
    }

    @SafeVarargs
    private void updateKeysList(Map.Entry<K, V> ... entries) {
        LinkedHashSet uniqueKeys = this.orderedKeys.stream().map(Reference::get).collect(Collectors.toCollection(LinkedHashSet::new));
        List keys = Stream.of(entries).map(Map.Entry::getKey).collect(Collectors.toList());
        uniqueKeys.addAll(keys);
        this.orderedKeys = uniqueKeys.stream().map(WeakReference::new).collect(Collectors.toCollection(LinkedList::new));
        this.clearReferences();
    }

    public void combine(BindingsMap<K, V> source) {
        LinkedHashSet uniqueKeys = Stream.concat(this.orderedKeys.stream(), source.orderedKeys.stream()).map(Reference::get).collect(Collectors.toCollection(LinkedHashSet::new));
        this.orderedKeys = uniqueKeys.stream().map(WeakReference::new).collect(LinkedList::new, LinkedList::add, LinkedList::addAll);
        this.clearReferences();
        for (Map.Entry entry : source.entrySet()) {
            super.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        this.updateKeysList(key);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.putAll((Map.Entry[])m.entrySet().toArray(Map.Entry[]::new));
    }

    @SafeVarargs
    public final void putAll(Map.Entry<K, V> ... entries) {
        this.updateKeysList(entries);
        for (Map.Entry<K, V> entry : entries) {
            super.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        this.orderedKeys.removeIf(reference -> reference != null && reference.get() == key);
        return super.remove(key);
    }

    @Override
    public void clear() {
        this.orderedKeys.clear();
        super.clear();
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    public LinkedList<WeakReference<K>> unmodifiableKeysList() {
        return new LinkedList<WeakReference<K>>(this.orderedKeys);
    }

    public K getFirstKey() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.orderedKeys.getFirst().get();
    }

    public K getLastKey() {
        if (this.isEmpty()) {
            return null;
        }
        return (K)this.orderedKeys.getLast().get();
    }
}

