/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.builders.base.BaseListViewBuilder;
import io.github.palexdev.materialfx.controls.MFXListView;
import io.github.palexdev.materialfx.controls.cell.MFXListCell;
import java.util.function.Function;

public class ListBuilder<T>
extends BaseListViewBuilder<T, MFXListCell<T>, MFXListView<T>> {
    public ListBuilder() {
        this(new MFXListView());
    }

    public ListBuilder(MFXListView<T> listView) {
        super(listView);
    }

    public static <T> ListBuilder<T> list() {
        return new ListBuilder<T>();
    }

    public static <T> ListBuilder<T> list(MFXListView<T> listView) {
        return new ListBuilder<T>(listView);
    }

    public ListBuilder<T> scrollBy(double pixels) {
        ((MFXListView)this.node).scrollBy(pixels);
        return this;
    }

    public ListBuilder<T> scrollTo(int index) {
        ((MFXListView)this.node).scrollTo(index);
        return this;
    }

    public ListBuilder<T> scrollToFirst() {
        ((MFXListView)this.node).scrollToFirst();
        return this;
    }

    public ListBuilder<T> scrollToLast() {
        ((MFXListView)this.node).scrollToLast();
        return this;
    }

    public ListBuilder<T> scrollToPixel(double pixel) {
        ((MFXListView)this.node).scrollToPixel(pixel);
        return this;
    }

    public ListBuilder<T> setHSpeed(double unit, double block) {
        ((MFXListView)this.node).setHSpeed(unit, block);
        return this;
    }

    public ListBuilder<T> setVSpeed(double unit, double block) {
        ((MFXListView)this.node).setVSpeed(unit, block);
        return this;
    }

    public ListBuilder<T> setCellFactory(Function<T, MFXListCell<T>> cellFactory) {
        ((MFXListView)this.node).setCellFactory(cellFactory);
        return this;
    }

    public ListBuilder<T> enableSmoothScrolling(double speed) {
        ((MFXListView)this.node).features().enableSmoothScrolling(speed);
        return this;
    }

    public ListBuilder<T> enableSmoothScrolling(double speed, double trackPadAdjustment) {
        ((MFXListView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment);
        return this;
    }

    public ListBuilder<T> enableSmoothScrolling(double speed, double trackPadAdjustment, double scrollThreshold) {
        ((MFXListView)this.node).features().enableSmoothScrolling(speed, trackPadAdjustment, scrollThreshold);
        return this;
    }

    public ListBuilder<T> enableBounceEffect() {
        ((MFXListView)this.node).features().enableBounceEffect();
        return this;
    }

    public ListBuilder<T> enableBounceEffect(double strength, double maxOverscroll) {
        ((MFXListView)this.node).features().enableBounceEffect(strength, maxOverscroll);
        return this;
    }
}

