/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.control;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.builders.base.ControlBuilder;
import io.github.palexdev.materialfx.controls.MFXSlider;
import io.github.palexdev.materialfx.enums.SliderEnums;
import java.util.function.Supplier;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.Region;

public class SliderBuilder
extends ControlBuilder<MFXSlider> {
    public SliderBuilder() {
        this(new MFXSlider());
    }

    public SliderBuilder(MFXSlider control) {
        super(control);
    }

    public static SliderBuilder slider() {
        return new SliderBuilder();
    }

    public static SliderBuilder slider(MFXSlider slider) {
        return new SliderBuilder(slider);
    }

    public SliderBuilder setMin(double min) {
        ((MFXSlider)this.node).setMin(min);
        return this;
    }

    public SliderBuilder setMax(double max) {
        ((MFXSlider)this.node).setMax(max);
        return this;
    }

    public SliderBuilder setValue(double value) {
        ((MFXSlider)this.node).setValue(value);
        return this;
    }

    public SliderBuilder setThumbSupplier(Supplier<Node> thumbSupplier) {
        ((MFXSlider)this.node).setThumbSupplier(thumbSupplier);
        return this;
    }

    public SliderBuilder setPopupSupplier(Supplier<Region> popupSupplier) {
        ((MFXSlider)this.node).setPopupSupplier(popupSupplier);
        return this;
    }

    public SliderBuilder setPopupPadding(double popupPadding) {
        ((MFXSlider)this.node).setPopupPadding(popupPadding);
        return this;
    }

    public SliderBuilder setDecimalPrecision(int decimalPrecision) {
        ((MFXSlider)this.node).setDecimalPrecision(decimalPrecision);
        return this;
    }

    public SliderBuilder setEnableKeyboard(boolean enableKeyboard) {
        ((MFXSlider)this.node).setEnableKeyboard(enableKeyboard);
        return this;
    }

    public SliderBuilder setRanges1(NumberRange<Double> ... ranges) {
        ((MFXSlider)this.node).getRanges1().setAll((Object[])ranges);
        return this;
    }

    public SliderBuilder setRanges2(NumberRange<Double> ... ranges) {
        ((MFXSlider)this.node).getRanges2().setAll((Object[])ranges);
        return this;
    }

    public SliderBuilder setRanges3(NumberRange<Double> ... ranges) {
        ((MFXSlider)this.node).getRanges3().setAll((Object[])ranges);
        return this;
    }

    public SliderBuilder setSliderMode(SliderEnums.SliderMode sliderMode) {
        ((MFXSlider)this.node).setSliderMode(sliderMode);
        return this;
    }

    public SliderBuilder setUnitIncrement(double unitIncrement) {
        ((MFXSlider)this.node).setUnitIncrement(unitIncrement);
        return this;
    }

    public SliderBuilder setAlternativeUnitIncrement(double alternativeUnitIncrement) {
        ((MFXSlider)this.node).setAlternativeUnitIncrement(alternativeUnitIncrement);
        return this;
    }

    public SliderBuilder setTickUnit(double tickUnit) {
        ((MFXSlider)this.node).setTickUnit(tickUnit);
        return this;
    }

    public SliderBuilder setShowMajorTicks(boolean showMajorTicks) {
        ((MFXSlider)this.node).setShowMajorTicks(showMajorTicks);
        return this;
    }

    public SliderBuilder setShowMinorTicks(boolean showMinorTicks) {
        ((MFXSlider)this.node).setShowMinorTicks(showMinorTicks);
        return this;
    }

    public SliderBuilder setShowTicksAtEdges(boolean showTicksAtEdges) {
        ((MFXSlider)this.node).setShowTicksAtEdges(showTicksAtEdges);
        return this;
    }

    public SliderBuilder setMinorTicksCount(int minorTicksCount) {
        ((MFXSlider)this.node).setMinorTicksCount(minorTicksCount);
        return this;
    }

    public SliderBuilder setAnimateOnPress(boolean animateOnPress) {
        ((MFXSlider)this.node).setAnimateOnPress(animateOnPress);
        return this;
    }

    public SliderBuilder setBidirectional(boolean bidirectional) {
        ((MFXSlider)this.node).setBidirectional(bidirectional);
        return this;
    }

    public SliderBuilder setOrientation(Orientation orientation) {
        ((MFXSlider)this.node).setOrientation(orientation);
        return this;
    }

    public SliderBuilder setPopupSide(SliderEnums.SliderPopupSide popupSide) {
        ((MFXSlider)this.node).setPopupSide(popupSide);
        return this;
    }
}

