/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

public class BackgroundBuilder {
    private final List<BackgroundFill> fills = new ArrayList<BackgroundFill>();
    private final List<BackgroundImage> images = new ArrayList<BackgroundImage>();

    public static BackgroundBuilder build() {
        return new BackgroundBuilder();
    }

    public BackgroundBuilder addFill(BackgroundFill fill) {
        this.fills.add(fill);
        return this;
    }

    public BackgroundBuilder addFill(Paint fill) {
        return this.addFill(fill, CornerRadii.EMPTY);
    }

    public BackgroundBuilder addFill(Paint fill, CornerRadii cornerRadii) {
        return this.addFill(fill, cornerRadii, Insets.EMPTY);
    }

    public BackgroundBuilder addFill(Paint fill, CornerRadii cornerRadii, Insets insets) {
        this.fills.add(new BackgroundFill(fill, cornerRadii, insets));
        return this;
    }

    public BackgroundBuilder addImage(BackgroundImage image) {
        this.images.add(image);
        return this;
    }

    public BackgroundBuilder addImage(Image image, BackgroundRepeat repeatX, BackgroundRepeat repeatY, BackgroundPosition position, BackgroundSize size) {
        this.images.add(new BackgroundImage(image, repeatX, repeatY, position, size));
        return this;
    }

    public Background get() {
        return new Background(this.fills, this.images);
    }
}

