/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderImage;
import javafx.scene.layout.BorderRepeat;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Paint;

public class BorderBuilder {
    private final List<BorderStroke> strokes = new ArrayList<BorderStroke>();
    private final List<BorderImage> images = new ArrayList<BorderImage>();

    public static BorderBuilder build() {
        return new BorderBuilder();
    }

    public BorderBuilder addFill(BorderStroke stroke) {
        this.strokes.add(stroke);
        return this;
    }

    public BorderBuilder addFill(Paint stroke, BorderStrokeStyle style, CornerRadii cornerRadii, BorderWidths widths, Insets insets) {
        this.strokes.add(new BorderStroke(stroke, style, cornerRadii, widths, insets));
        return this;
    }

    public BorderBuilder addImage(BorderImage image) {
        this.images.add(image);
        return this;
    }

    public BorderBuilder addImage(Image image, BorderWidths widths, Insets insets, BorderWidths slices, boolean filled, BorderRepeat repeatX, BorderRepeat repeatY) {
        this.images.add(new BorderImage(image, widths, insets, slices, filled, repeatX, repeatY));
        return this;
    }

    public Border get() {
        return new Border(this.strokes, this.images);
    }
}

