/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.layout.PaneBuilder;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class GridPaneBuilder
extends PaneBuilder<GridPane> {
    public GridPaneBuilder() {
        this(new GridPane());
    }

    public GridPaneBuilder(GridPane pane) {
        super(pane);
    }

    public static GridPaneBuilder gridPane() {
        return new GridPaneBuilder();
    }

    public static GridPaneBuilder gridPane(GridPane pane) {
        return new GridPaneBuilder(pane);
    }

    public GridPaneBuilder setRowIndex(Node child, int rowIndex) {
        GridPane.setRowIndex((Node)child, (Integer)rowIndex);
        return this;
    }

    public GridPaneBuilder setColumnIndex(Node child, int columnIndex) {
        GridPane.setColumnIndex((Node)child, (Integer)columnIndex);
        return this;
    }

    public GridPaneBuilder setRowSpan(Node child, int rowSpan) {
        GridPane.setRowSpan((Node)child, (Integer)rowSpan);
        return this;
    }

    public GridPaneBuilder setColumnSpan(Node child, int columnSpan) {
        GridPane.setColumnSpan((Node)child, (Integer)columnSpan);
        return this;
    }

    public GridPaneBuilder setMargin(Node child, Insets margin) {
        GridPane.setMargin((Node)child, (Insets)margin);
        return this;
    }

    public GridPaneBuilder setHAlignment(Node child, HPos hPos) {
        GridPane.setHalignment((Node)child, (HPos)hPos);
        return this;
    }

    public GridPaneBuilder setVAlignment(Node child, VPos vPos) {
        GridPane.setValignment((Node)child, (VPos)vPos);
        return this;
    }

    public GridPaneBuilder setHGrow(Node child, Priority priority) {
        GridPane.setHgrow((Node)child, (Priority)priority);
        return this;
    }

    public GridPaneBuilder setVGrow(Node child, Priority priority) {
        GridPane.setVgrow((Node)child, (Priority)priority);
        return this;
    }

    public GridPaneBuilder setFillWidth(Node child, boolean fillWidth) {
        GridPane.setFillWidth((Node)child, (Boolean)fillWidth);
        return this;
    }

    public GridPaneBuilder setFillHeight(Node child, boolean fillHeight) {
        GridPane.setFillHeight((Node)child, (Boolean)fillHeight);
        return this;
    }

    public GridPaneBuilder setConstraints(Node child, int columnIndex, int rowIndex) {
        GridPane.setConstraints((Node)child, (int)columnIndex, (int)rowIndex);
        return this;
    }

    public GridPaneBuilder setConstraints(Node child, int columnIndex, int rowIndex, int columnSpan, int rowspan) {
        GridPane.setConstraints((Node)child, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowspan);
        return this;
    }

    public GridPaneBuilder setConstraints(Node child, int columnIndex, int rowIndex, int columnSpan, int rowspan, HPos hAlignment, VPos vAlignment) {
        GridPane.setConstraints((Node)child, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowspan, (HPos)hAlignment, (VPos)vAlignment);
        return this;
    }

    public GridPaneBuilder setConstraints(Node child, int columnIndex, int rowIndex, int columnSpan, int rowspan, HPos hAlignment, VPos vAlignment, Priority hGrow, Priority vGrow) {
        GridPane.setConstraints((Node)child, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowspan, (HPos)hAlignment, (VPos)vAlignment, (Priority)hGrow, (Priority)vGrow);
        return this;
    }

    public GridPaneBuilder setConstraints(Node child, int columnIndex, int rowIndex, int columnSpan, int rowspan, HPos hAlignment, VPos vAlignment, Priority hGrow, Priority vGrow, Insets margin) {
        GridPane.setConstraints((Node)child, (int)columnIndex, (int)rowIndex, (int)columnSpan, (int)rowspan, (HPos)hAlignment, (VPos)vAlignment, (Priority)hGrow, (Priority)vGrow, (Insets)margin);
        return this;
    }

    public GridPaneBuilder clearConstraints(Node child) {
        GridPane.clearConstraints((Node)child);
        return this;
    }

    public GridPaneBuilder setHGap(double hGap) {
        ((GridPane)this.node).setHgap(hGap);
        return this;
    }

    public GridPaneBuilder setVGap(double vGap) {
        ((GridPane)this.node).setVgap(vGap);
        return this;
    }

    public GridPaneBuilder setAlignment(Pos alignment) {
        ((GridPane)this.node).setAlignment(alignment);
        return this;
    }

    public GridPaneBuilder setGridLinesVisible(boolean gridLinesVisible) {
        ((GridPane)this.node).setGridLinesVisible(gridLinesVisible);
        return this;
    }

    public GridPaneBuilder addRowConstraints(RowConstraints ... constraints) {
        ((GridPane)this.node).getRowConstraints().addAll((Object[])constraints);
        return this;
    }

    public GridPaneBuilder setRowConstraints(RowConstraints ... constraints) {
        ((GridPane)this.node).getRowConstraints().setAll((Object[])constraints);
        return this;
    }

    public GridPaneBuilder addColumnConstraints(ColumnConstraints ... constraints) {
        ((GridPane)this.node).getColumnConstraints().addAll((Object[])constraints);
        return this;
    }

    public GridPaneBuilder setColumnConstraints(ColumnConstraints ... constraints) {
        ((GridPane)this.node).getColumnConstraints().setAll((Object[])constraints);
        return this;
    }

    public GridPaneBuilder add(Node child, int columnIndex, int rowIndex) {
        ((GridPane)this.node).add(child, columnIndex, rowIndex);
        return this;
    }

    public GridPaneBuilder add(Node child, int columnIndex, int rowIndex, int colspan, int rowspan) {
        ((GridPane)this.node).add(child, columnIndex, rowIndex, colspan, rowspan);
        return this;
    }

    public GridPaneBuilder addRow(int rowIndex, Node ... children) {
        ((GridPane)this.node).addRow(rowIndex, children);
        return this;
    }

    public GridPaneBuilder addColumn(int columnIndex, Node ... children) {
        ((GridPane)this.node).addColumn(columnIndex, children);
        return this;
    }
}

