/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.layout.PaneBuilder;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class HBoxBuilder
extends PaneBuilder<HBox> {
    public HBoxBuilder() {
        this(new HBox());
    }

    public HBoxBuilder(HBox pane) {
        super(pane);
    }

    public static HBoxBuilder hBox() {
        return new HBoxBuilder();
    }

    public static HBoxBuilder hBox(HBox pane) {
        return new HBoxBuilder(pane);
    }

    public HBoxBuilder setHGrow(Node child, Priority priority) {
        HBox.setHgrow((Node)child, (Priority)priority);
        return this;
    }

    public HBoxBuilder setMargin(Node child, Insets margin) {
        HBox.setMargin((Node)child, (Insets)margin);
        return this;
    }

    public HBoxBuilder clearConstraints(Node child) {
        HBox.clearConstraints((Node)child);
        return this;
    }

    public HBoxBuilder setSpacing(double spacing) {
        ((HBox)this.node).setSpacing(spacing);
        return this;
    }

    public HBoxBuilder setAlignment(Pos alignment) {
        ((HBox)this.node).setAlignment(alignment);
        return this;
    }

    public HBoxBuilder setFillHeight(boolean fillHeight) {
        ((HBox)this.node).setFillHeight(fillHeight);
        return this;
    }
}

