/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.builders.layout;

import io.github.palexdev.materialfx.builders.layout.PaneBuilder;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.TilePane;

public class TilePaneBuilder
extends PaneBuilder<TilePane> {
    public TilePaneBuilder() {
        this(new TilePane());
    }

    public TilePaneBuilder(TilePane pane) {
        super(pane);
    }

    public static TilePaneBuilder tilePane() {
        return new TilePaneBuilder();
    }

    public static TilePaneBuilder tilePane(TilePane pane) {
        return new TilePaneBuilder(pane);
    }

    public TilePaneBuilder setAlignment(Node node, Pos alignment) {
        TilePane.setAlignment((Node)node, (Pos)alignment);
        return this;
    }

    public TilePaneBuilder setMargin(Node node, Insets margin) {
        TilePane.setMargin((Node)node, (Insets)margin);
        return this;
    }

    public TilePaneBuilder clearConstraints(Node child) {
        TilePane.clearConstraints((Node)child);
        return this;
    }

    public TilePaneBuilder setPrefRows(int prefRows) {
        ((TilePane)this.node).setPrefRows(prefRows);
        return this;
    }

    public TilePaneBuilder setPrefColumns(int prefColumns) {
        ((TilePane)this.node).setPrefColumns(prefColumns);
        return this;
    }

    public TilePaneBuilder setPrefTileWidth(double prefTileWidth) {
        ((TilePane)this.node).setPrefTileWidth(prefTileWidth);
        return this;
    }

    public TilePaneBuilder setPrefTileHeight(double prefTileHeight) {
        ((TilePane)this.node).setPrefTileHeight(prefTileHeight);
        return this;
    }

    public TilePaneBuilder setHGap(double hGap) {
        ((TilePane)this.node).setHgap(hGap);
        return this;
    }

    public TilePaneBuilder setVGap(double vGap) {
        ((TilePane)this.node).setVgap(vGap);
        return this;
    }

    public TilePaneBuilder setAlignment(Pos alignment) {
        ((TilePane)this.node).setAlignment(alignment);
        return this;
    }

    public TilePaneBuilder setTileAlignment(Pos tileAlignment) {
        ((TilePane)this.node).setTileAlignment(tileAlignment);
        return this;
    }
}

