/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.collections;

import io.github.palexdev.materialfx.beans.properties.functional.ComparatorProperty;
import io.github.palexdev.materialfx.beans.properties.functional.PredicateProperty;
import io.github.palexdev.materialfx.collections.NonIterableChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public class TransformableList<T>
extends TransformationList<T, T> {
    private final List<Integer> indexes = new ArrayList<Integer>();
    private boolean reversed = false;
    private final PredicateProperty<T> predicate = new PredicateProperty<T>(){

        protected void invalidated() {
            TransformableList.this.update();
        }
    };
    private final ComparatorProperty<T> comparator = new ComparatorProperty<T>(){

        protected void invalidated() {
            TransformableList.this.update();
        }
    };

    public TransformableList(ObservableList<? extends T> source) {
        this(source, null);
    }

    public TransformableList(ObservableList<? extends T> source, Predicate<T> predicate) {
        this(source, predicate, null);
    }

    public TransformableList(ObservableList<? extends T> source, Predicate<T> predicate, Comparator<T> comparator) {
        super(source);
        this.setPredicate(predicate);
        this.setComparator(comparator);
        this.update();
    }

    public int viewToSource(int index) {
        return this.getSourceIndex(index);
    }

    public int sourceToView(int index) {
        return this.getViewIndex(index);
    }

    private void update() {
        this.indexes.clear();
        this.indexes.addAll(this.computeIndexes());
        if (this.hasListeners()) {
            this.fireChange(new NonIterableChange.GenericAddRemoveChange(0, this.size(), new ArrayList(this), this));
        }
    }

    private Collection<Integer> computeIndexes() {
        Predicate<T> filter = this.getPredicate();
        Comparator sorter = this.getComparator();
        SortedMap sourceMap = filter != null ? (SortedMap)IntStream.range(0, this.getSource().size()).filter(index -> filter.test(this.getSource().get(index))).collect(TreeMap::new, (map, index) -> map.put(index, this.getSource().get(index)), TreeMap::putAll) : (SortedMap)IntStream.range(0, this.getSource().size()).collect(TreeMap::new, (map, index) -> map.put(index, this.getSource().get(index)), TreeMap::putAll);
        return sorter != null ? (Collection)sourceMap.entrySet().stream().sorted((o1, o2) -> sorter.compare(o1.getValue(), o2.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()) : sourceMap.keySet();
    }

    public Predicate<? super T> getPredicate() {
        return (Predicate)this.predicate.get();
    }

    public PredicateProperty<T> predicateProperty() {
        return this.predicate;
    }

    public void setPredicate(Predicate<T> predicate) {
        this.predicate.set(predicate);
    }

    public Comparator<T> getComparator() {
        return (Comparator)this.comparator.get();
    }

    public ComparatorProperty<T> comparatorProperty() {
        return this.comparator;
    }

    public void setComparator(Comparator<T> comparator) {
        this.reversed = false;
        this.comparator.set(comparator);
    }

    public void setComparator(Comparator<T> comparator, boolean reversed) {
        this.reversed = reversed;
        this.comparator.set(comparator);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    protected void sourceChanged(ListChangeListener.Change<? extends T> c) {
        this.beginChange();
        this.update();
        this.endChange();
    }

    public int size() {
        return this.indexes.size();
    }

    public T get(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return (T)this.getSource().get(this.indexes.get(index).intValue());
    }

    public int getSourceIndex(int index) {
        if (index > this.size()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.indexes.get(index);
    }

    public int getViewIndex(int index) {
        int viewIndex = this.reversed ? Collections.binarySearch(this.indexes, index, Collections.reverseOrder()) : Collections.binarySearch(this.indexes, index);
        return viewIndex < 0 ? -1 : viewIndex;
    }
}

