/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.collections;

import io.github.palexdev.materialfx.beans.properties.functional.ComparatorProperty;
import io.github.palexdev.materialfx.beans.properties.functional.PredicateProperty;
import io.github.palexdev.materialfx.collections.TransformableList;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class TransformableListWrapper<T>
extends AbstractList<T>
implements ObservableList<T> {
    private final ObservableList<T> source;
    private final TransformableList<T> transformableList;

    public TransformableListWrapper(ObservableList<T> source) {
        this.source = source;
        this.transformableList = new TransformableList<T>(source);
    }

    public void addListener(ListChangeListener<? super T> listener) {
        this.transformableList.addListener(listener);
    }

    public void removeListener(ListChangeListener<? super T> listener) {
        this.transformableList.removeListener(listener);
    }

    @Override
    public boolean add(T t) {
        return this.source.add(t);
    }

    @Override
    public T set(int index, T element) {
        return (T)this.source.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.source.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)this.source.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.transformableList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.transformableList.lastIndexOf(o);
    }

    @Override
    public void clear() {
        this.source.clear();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.source.addAll(index, c);
    }

    public boolean addAll(T ... elements) {
        return this.source.addAll((Object[])elements);
    }

    public boolean setAll(T ... elements) {
        return this.source.setAll((Object[])elements);
    }

    public boolean setAll(Collection<? extends T> col) {
        return this.source.setAll(col);
    }

    public boolean removeAll(T ... elements) {
        return this.source.removeAll((Object[])elements);
    }

    public boolean retainAll(T ... elements) {
        return this.source.retainAll((Object[])elements);
    }

    public void remove(int from, int to) {
        this.source.remove(from, to);
    }

    public void addListener(InvalidationListener listener) {
        this.transformableList.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.transformableList.removeListener(listener);
    }

    @Override
    public T get(int index) {
        return this.transformableList.get(index);
    }

    @Override
    public int size() {
        return this.transformableList.size();
    }

    public ObservableList<? extends T> getSource() {
        return this.transformableList.getSource();
    }

    public int viewToSource(int index) {
        return this.transformableList.viewToSource(index);
    }

    public int sourceToView(int index) {
        return this.transformableList.sourceToView(index);
    }

    public Predicate<? super T> getPredicate() {
        return this.transformableList.getPredicate();
    }

    public PredicateProperty<T> predicateProperty() {
        return this.transformableList.predicateProperty();
    }

    public void setPredicate(Predicate<T> predicate) {
        this.transformableList.setPredicate(predicate);
    }

    public Comparator<T> getComparator() {
        return this.transformableList.getComparator();
    }

    public ComparatorProperty<T> comparatorProperty() {
        return this.transformableList.comparatorProperty();
    }

    public void setComparator(Comparator<T> comparator) {
        this.transformableList.setComparator(comparator);
    }

    public void setComparator(Comparator<T> sorter, boolean reversed) {
        this.transformableList.setComparator(sorter, reversed);
    }

    public boolean isReversed() {
        return this.transformableList.isReversed();
    }

    public void setReversed(boolean reversed) {
        this.transformableList.setReversed(reversed);
    }

    public TransformableList<T> getTransformableList() {
        return this.transformableList;
    }
}

