/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.MFXPasswordField;
import io.github.palexdev.materialfx.controls.MFXTextField;
import java.util.ArrayList;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.TextFieldSkin;
import javafx.scene.text.Text;

public class BoundTextField
extends TextField {
    private MFXTextField textField;

    public BoundTextField(MFXTextField textField) {
        this.textField = textField;
        this.setPromptText(textField.getPromptText());
        this.setText(textField.getText());
        this.setFont(textField.getFont());
        this.setEditable(textField.isEditable());
        this.setAlignment(textField.getAlignment());
        this.setPrefColumnCount(textField.getPrefColumnCount());
        this.selectRange(textField.getSelection().getStart(), textField.getSelection().getEnd());
        this.positionCaret(textField.getCaretPosition());
        this.promptTextProperty().bind((ObservableValue)textField.promptTextProperty());
        this.textProperty().bindBidirectional((Property)textField.textProperty());
        this.fontProperty().bind((ObservableValue)textField.fontProperty());
        this.editableProperty().bind((ObservableValue)textField.editableProperty());
        this.alignmentProperty().bind((ObservableValue)textField.alignmentProperty());
        this.prefColumnCountProperty().bind((ObservableValue)textField.prefColumnCountProperty());
    }

    protected Skin<?> createDefaultSkin() {
        return new CustomTextFieldSkin(this);
    }

    public void dispose() {
        this.textField = null;
    }

    public void copy() {
        MFXPasswordField passwordField;
        if (this.textField instanceof MFXPasswordField && !(passwordField = (MFXPasswordField)this.textField).isAllowCopy()) {
            return;
        }
        super.copy();
    }

    public void cut() {
        MFXPasswordField passwordField;
        if (this.textField instanceof MFXPasswordField && !(passwordField = (MFXPasswordField)this.textField).isAllowCut()) {
            return;
        }
        super.cut();
    }

    public void paste() {
        MFXPasswordField passwordField;
        if (this.textField instanceof MFXPasswordField && !(passwordField = (MFXPasswordField)this.textField).isAllowPaste()) {
            return;
        }
        super.paste();
    }

    private class CustomTextFieldSkin
    extends TextFieldSkin {
        private final StringBinding textBinding;

        public CustomTextFieldSkin(final TextField field) {
            Text textNode;
            super(field);
            if (!field.getPromptText().isEmpty()) {
                try {
                    ArrayList textNodes = new ArrayList(BoundTextField.this.lookupAll(".text"));
                    textNode = (Text)textNodes.get(textNodes.size() - 1);
                }
                catch (Exception ex) {
                    textNode = (Text)BoundTextField.this.lookup(".text");
                }
            } else {
                textNode = (Text)BoundTextField.this.lookup(".text");
            }
            this.textBinding = new StringBinding(){
                {
                    this.bind(new Observable[]{field.textProperty()});
                }

                protected String computeValue() {
                    return CustomTextFieldSkin.this.maskText(field.textProperty().getValueSafe());
                }
            };
            textNode.textProperty().bind((ObservableValue)this.textBinding);
            this.setCaretAnimating(BoundTextField.this.textField.getCaretVisible());
            BoundTextField.this.textField.caretVisibleProperty().addListener(invalidated -> this.setCaretAnimating(BoundTextField.this.textField.getCaretVisible()));
            if (BoundTextField.this.textField instanceof MFXPasswordField) {
                MFXPasswordField passwordField = (MFXPasswordField)BoundTextField.this.textField;
                passwordField.showPasswordProperty().addListener((observable, oldValue, newValue) -> this.textBinding.invalidate());
                passwordField.hideCharacterProperty().addListener((observable, oldValue, newValue) -> this.textBinding.invalidate());
            }
        }

        protected String maskText(String txt) {
            if (BoundTextField.this.textField instanceof MFXPasswordField) {
                MFXPasswordField passwordField = (MFXPasswordField)BoundTextField.this.textField;
                if (passwordField.isShowPassword()) {
                    return txt;
                }
                int n = txt.length();
                return passwordField.getHideCharacter().repeat(n);
            }
            return txt;
        }

        public void setCaretAnimating(boolean value) {
            super.setCaretAnimating(value && BoundTextField.this.textField.getCaretVisible());
        }
    }
}

