/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.BiFunctionProperty;
import io.github.palexdev.materialfx.beans.properties.functional.ConsumerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.base.MFXCombo;
import io.github.palexdev.materialfx.controls.cell.MFXComboBoxCell;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.selection.ComboBoxSelectionModel;
import io.github.palexdev.materialfx.skins.MFXComboBoxSkin;
import io.github.palexdev.materialfx.utils.ListChangeProcessor;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.NumberUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.virtualizedfx.beans.NumberRange;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.utils.ListChangeHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import javafx.util.StringConverter;

public class MFXComboBox<T>
extends MFXTextField
implements MFXCombo<T> {
    private final String STYLE_CLASS = "mfx-combo-box";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXComboBox.css");
    private final ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(false);
    private final ObjectProperty<Alignment> popupAlignment = new SimpleObjectProperty((Object)Alignment.of(HPos.CENTER, VPos.BOTTOM));
    private final DoubleProperty popupOffsetX = new SimpleDoubleProperty(0.0);
    private final DoubleProperty popupOffsetY = new SimpleDoubleProperty(3.0);
    private final BiFunctionProperty<Node, Boolean, Animation> animationProvider = new BiFunctionProperty();
    private final ObjectProperty<T> value = new SimpleObjectProperty();
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty();
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty();
    private final ComboBoxSelectionModel<T> selectionModel = new ComboBoxSelectionModel<T>(this.items);
    private final FunctionProperty<T, Cell<T>> cellFactory = new FunctionProperty<Object, Cell>(t -> new MFXComboBoxCell<Object>(this, t));
    private final ListChangeListener<? super T> itemsChanged = this::itemsChanged;
    private final ConsumerProperty<String> onCommit = new ConsumerProperty();
    private final ConsumerProperty<String> onCancel = new ConsumerProperty();
    protected static final PseudoClass POPUP_OPEN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"popup");
    private final StyleableBooleanProperty scrollOnOpen = new StyleableBooleanProperty(StyleableProperties.SCROLL_ON_OPEN, this, "scrollOnOpen", false);
    public static final EventType<Event> ON_SHOWING = new EventType(Event.ANY, "ON_SHOWING");
    public static final EventType<Event> ON_SHOWN = new EventType(Event.ANY, "ON_SHOWN");
    public static final EventType<Event> ON_HIDING = new EventType(Event.ANY, "ON_HIDING");
    public static final EventType<Event> ON_HIDDEN = new EventType(Event.ANY, "ON_HIDDEN");
    private final EventHandlerProperty<Event> onShowing = new EventHandlerProperty<Event>(){

        protected void invalidated() {
            MFXComboBox.this.setEventHandler(ON_SHOWING, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<Event> onShown = new EventHandlerProperty<Event>(){

        protected void invalidated() {
            MFXComboBox.this.setEventHandler(ON_SHOWN, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<Event> onHiding = new EventHandlerProperty<Event>(){

        protected void invalidated() {
            MFXComboBox.this.setEventHandler(ON_HIDING, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<Event> onHidden = new EventHandlerProperty<Event>(){

        protected void invalidated() {
            MFXComboBox.this.setEventHandler(ON_HIDDEN, (EventHandler)this.get());
        }
    };

    public MFXComboBox() {
        this(FXCollections.observableArrayList());
    }

    public MFXComboBox(ObservableList<T> items) {
        this.setItems(items);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-combo-box");
        this.setAllowEdit(false);
        this.setSelectable(false);
        MFXIconWrapper icon = new MFXIconWrapper("mfx-caret-down", 12.0, 24.0);
        icon.rippleGeneratorBehavior(event -> {
            double x = event != null ? event.getX() : icon.getSize() / 2.0;
            double y = event != null ? event.getY() : icon.getSize() / 2.0;
            return PositionBean.of(x, y);
        });
        NodeUtils.makeRegionCircular((Region)icon);
        this.setTrailingIcon((Node)icon);
        icon.getStyleClass().add((Object)"caret");
        this.setAnimationProvider((node, showing) -> {
            RotateTransition transition = new RotateTransition(Duration.millis((double)200.0), node);
            transition.setInterpolator(Interpolator.EASE_OUT);
            transition.setToAngle(showing != false ? 180.0 : 0.0);
            return transition;
        });
        this.setConverter(FunctionalStringConverter.to(t -> t != null ? t.toString() : ""));
        this.showing.addListener(invalidated -> this.pseudoClassStateChanged(POPUP_OPEN_PSEUDO_CLASS, this.showing.get()));
        this.items.addListener((observable, oldValue, newValue) -> {
            oldValue.removeListener(this.itemsChanged);
            newValue.addListener(this.itemsChanged);
        });
        this.getItems().addListener(this::itemsChanged);
    }

    @Override
    public void defaultContextMenu() {
        MFXContextMenuItem selectFirst = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-first-page", 16.0)).setText(I18N.getOrDefault("comboBox.contextMenu.selectFirst", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectFirst())).get();
        MFXContextMenuItem selectNext = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-next", 18.0)).setText(I18N.getOrDefault("comboBox.contextMenu.selectNext", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectNext())).get();
        MFXContextMenuItem selectPrevious = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-back", 18.0)).setText(I18N.getOrDefault("comboBox.contextMenu.selectPrevious", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectPrevious())).get();
        MFXContextMenuItem selectLast = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-last-page", 16.0)).setText(I18N.getOrDefault("comboBox.contextMenu.selectLast", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectLast())).get();
        MFXContextMenuItem resetSelection = MFXContextMenuItem.Builder.build().setIcon((Node)new MFXFontIcon("mfx-x", 16.0)).setText(I18N.getOrDefault("comboBox.contextMenu.clearSelection", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.clearSelection())).get();
        this.contextMenu = MFXContextMenu.Builder.build((Node)this).addItems(selectFirst, selectNext, selectPrevious, selectLast).addLineSeparator().addItem(resetSelection).installAndGet();
    }

    @Override
    public void show() {
        this.showing.set(true);
    }

    @Override
    public void hide() {
        this.showing.set(false);
    }

    @Override
    public void commit(String text) {
        if (this.getOnCommit() != null) {
            this.getOnCommit().accept(text);
        }
    }

    @Override
    public void cancel(String text) {
        if (this.getOnCancel() != null) {
            this.getOnCancel().accept(text);
        }
    }

    protected void itemsChanged(ListChangeListener.Change<? extends T> change) {
        if (this.getSelectedIndex() == -1) {
            return;
        }
        if (change.getList().isEmpty()) {
            this.clearSelection();
            return;
        }
        ListChangeHelper.Change c = ListChangeHelper.processChange(change, (NumberRange)NumberRange.of((Number)0, (Number)Integer.MAX_VALUE));
        HashSet<Integer> indexes = new HashSet<Integer>();
        indexes.add(this.getSelectedIndex());
        ListChangeProcessor updater = new ListChangeProcessor(indexes);
        c.processReplacement((changed, removed) -> {
            int selected = this.getSelectedIndex();
            if (changed.contains(selected) || removed.contains(selected)) {
                this.selectItem(this.getItems().get(selected));
            }
        });
        c.processAddition((from, to, added) -> {
            updater.computeAddition(added.size(), (int)from);
            this.selectIndex(updater.getIndexes().toArray(new Integer[0])[0]);
        });
        c.processRemoval((from, to, removed) -> {
            updater.computeRemoval((Set<Integer>)removed, (int)from);
            int index = NumberUtils.clamp(updater.getIndexes().toArray(new Integer[0])[0], 0, this.getItems().size() - 1);
            this.selectIndex(index);
        });
        this.setValue(this.getSelectedItem());
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXComboBoxSkin(this, this.boundField);
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXComboBox.getClassCssMetaData();
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public void selectFirst() {
        this.selectionModel.selectFirst();
    }

    public void selectNext() {
        this.selectionModel.selectNext();
    }

    public void selectPrevious() {
        this.selectionModel.selectPrevious();
    }

    public void selectLast() {
        this.selectionModel.selectLast();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void selectIndex(int index) {
        this.selectionModel.selectIndex(index);
    }

    public void selectItem(T item) {
        this.selectionModel.selectItem(item);
    }

    public int getSelectedIndex() {
        return this.selectionModel.getSelectedIndex();
    }

    public ReadOnlyIntegerProperty selectedIndexProperty() {
        return this.selectionModel.selectedIndexProperty();
    }

    public T getSelectedItem() {
        return this.selectionModel.getSelectedItem();
    }

    public ReadOnlyObjectProperty<T> selectedItemProperty() {
        return this.selectionModel.selectedItemProperty();
    }

    @Override
    public MFXValidator getValidator() {
        return this.validator;
    }

    public boolean isScrollOnOpen() {
        return this.scrollOnOpen.get();
    }

    public StyleableBooleanProperty scrollOnOpenProperty() {
        return this.scrollOnOpen;
    }

    public void setScrollOnOpen(boolean scrollOnOpen) {
        this.scrollOnOpen.set(scrollOnOpen);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    private void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    public Alignment getPopupAlignment() {
        return (Alignment)this.popupAlignment.get();
    }

    public ObjectProperty<Alignment> popupAlignmentProperty() {
        return this.popupAlignment;
    }

    public void setPopupAlignment(Alignment popupAlignment) {
        this.popupAlignment.set((Object)popupAlignment);
    }

    public double getPopupOffsetX() {
        return this.popupOffsetX.get();
    }

    public DoubleProperty popupOffsetXProperty() {
        return this.popupOffsetX;
    }

    public void setPopupOffsetX(double popupOffsetX) {
        this.popupOffsetX.set(popupOffsetX);
    }

    public double getPopupOffsetY() {
        return this.popupOffsetY.get();
    }

    public DoubleProperty popupOffsetYProperty() {
        return this.popupOffsetY;
    }

    public void setPopupOffsetY(double popupOffsetY) {
        this.popupOffsetY.set(popupOffsetY);
    }

    public BiFunction<Node, Boolean, Animation> getAnimationProvider() {
        return (BiFunction)this.animationProvider.get();
    }

    public BiFunctionProperty<Node, Boolean, Animation> animationProviderProperty() {
        return this.animationProvider;
    }

    public void setAnimationProvider(BiFunction<Node, Boolean, Animation> animationProvider) {
        this.animationProvider.set(animationProvider);
    }

    @Override
    public T getValue() {
        return (T)this.value.get();
    }

    @Override
    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value.set(value);
    }

    @Override
    public StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    @Override
    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    @Override
    public void setConverter(StringConverter<T> converter) {
        this.converter.set(converter);
    }

    @Override
    public Consumer<String> getOnCommit() {
        return (Consumer)this.onCommit.get();
    }

    @Override
    public ConsumerProperty<String> onCommitProperty() {
        return this.onCommit;
    }

    @Override
    public void setOnCommit(Consumer<String> onCommit) {
        this.onCommit.set(onCommit);
    }

    @Override
    public Consumer<String> getOnCancel() {
        return (Consumer)this.onCancel.get();
    }

    @Override
    public ConsumerProperty<String> onCancelProperty() {
        return this.onCancel;
    }

    @Override
    public void setOnCancel(Consumer<String> onCancel) {
        this.onCancel.set(onCancel);
    }

    @Override
    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    @Override
    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    @Override
    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    @Override
    public Function<T, Cell<T>> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    @Override
    public ObjectProperty<Function<T, Cell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    @Override
    public void setCellFactory(Function<T, Cell<T>> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    @Override
    public ComboBoxSelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public EventHandler<Event> getOnShowing() {
        return (EventHandler)this.onShowing.get();
    }

    @Override
    public EventHandlerProperty<Event> onShowingProperty() {
        return this.onShowing;
    }

    @Override
    public void setOnShowing(EventHandler<Event> onShowing) {
        this.onShowing.set(onShowing);
    }

    @Override
    public EventHandler<Event> getOnShown() {
        return (EventHandler)this.onShown.get();
    }

    @Override
    public EventHandlerProperty<Event> onShownProperty() {
        return this.onShown;
    }

    @Override
    public void setOnShown(EventHandler<Event> onShown) {
        this.onShown.set(onShown);
    }

    @Override
    public EventHandler<Event> getOnHiding() {
        return (EventHandler)this.onHiding.get();
    }

    @Override
    public EventHandlerProperty<Event> onHidingProperty() {
        return this.onHiding;
    }

    @Override
    public void setOnHiding(EventHandler<Event> onHiding) {
        this.onHiding.set(onHiding);
    }

    @Override
    public EventHandler<Event> getOnHidden() {
        return (EventHandler)this.onHidden.get();
    }

    @Override
    public EventHandlerProperty<Event> onHiddenProperty() {
        return this.onHidden;
    }

    @Override
    public void setOnHidden(EventHandler<Event> onHidden) {
        this.onHidden.set(onHidden);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXComboBox<?>> FACTORY = new StyleablePropertyFactory(MFXTextField.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXComboBox<?>, Boolean> SCROLL_ON_OPEN;

        private StyleableProperties() {
        }

        static {
            SCROLL_ON_OPEN = FACTORY.createBooleanCssMetaData("-mfx-scroll-on-open", MFXComboBox::scrollOnOpenProperty, false);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(MFXTextField.getClassCssMetaData(), SCROLL_ON_OPEN);
        }
    }
}

