/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.NumberRangeProperty;
import io.github.palexdev.materialfx.beans.properties.functional.BiFunctionProperty;
import io.github.palexdev.materialfx.beans.properties.functional.ConsumerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.cell.MFXDateCell;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.skins.MFXDatePickerSkin;
import io.github.palexdev.materialfx.utils.DateTimeUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.others.ReusableScheduledExecutor;
import io.github.palexdev.materialfx.utils.others.dates.DateStringConverter;
import io.github.palexdev.materialfx.utils.others.dates.DayOfWeekStringConverter;
import io.github.palexdev.materialfx.utils.others.dates.MonthStringConverter;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public class MFXDatePicker
extends MFXTextField {
    private final String STYLE_CLASS = "mfx-date-picker";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXDatePicker.css");
    private final ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(false);
    private final ObjectProperty<Alignment> popupAlignment = new SimpleObjectProperty((Object)Alignment.of(HPos.CENTER, VPos.BOTTOM));
    private final DoubleProperty popupOffsetX = new SimpleDoubleProperty(0.0);
    private final DoubleProperty popupOffsetY = new SimpleDoubleProperty(3.0);
    private final ObjectProperty<LocalDate> value = new SimpleObjectProperty();
    private final SupplierProperty<StringConverter<LocalDate>> converterSupplier = new SupplierProperty();
    private final SupplierProperty<StringConverter<Month>> monthConverterSupplier = new SupplierProperty();
    private final SupplierProperty<StringConverter<DayOfWeek>> dayOfWeekConverterSupplier = new SupplierProperty();
    private final FunctionProperty<LocalDate, MFXDateCell> cellFactory = new FunctionProperty();
    private final ConsumerProperty<String> onCommit = new ConsumerProperty<String>(s -> this.setValue((LocalDate)this.getConverterSupplier().get().fromString(s)));
    private final ConsumerProperty<String> onCancel = new ConsumerProperty<String>(s -> this.setText(this.getConverterSupplier().get().toString((Object)this.getValue())));
    private final ObjectProperty<Locale> locale = new SimpleObjectProperty<Locale>(Locale.getDefault()){

        public void set(Locale newValue) {
            if (newValue == null) {
                super.set((Object)Locale.getDefault());
                return;
            }
            super.set((Object)newValue);
        }
    };
    private final ReadOnlyObjectWrapper<LocalDate> currentDate = new ReadOnlyObjectWrapper((Object)LocalDate.now());
    private final NumberRangeProperty<Integer> yearsRange = new NumberRangeProperty<Integer>(NumberRange.of(1900, 2100)){

        @Override
        public void set(NumberRange<Integer> newValue) {
            if (newValue == null) {
                super.set(NumberRange.of(1900, 2100));
                return;
            }
            super.set(newValue);
        }
    };
    private final BiFunctionProperty<Locale, YearMonth, Integer[][]> gridAlgorithm = new BiFunctionProperty<Locale, YearMonth, Integer[][]>(DateTimeUtils::fullIntMonthMatrix){

        public void set(BiFunction<Locale, YearMonth, Integer[][]> newValue) {
            if (newValue == null) {
                super.set(DateTimeUtils::partialIntMonthMatrix);
                return;
            }
            super.set(newValue);
        }
    };
    private YearMonth startingYearMonth;
    private boolean closePopupOnChange = true;
    private final ReusableScheduledExecutor executor;
    protected static final PseudoClass POPUP_OPEN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"popup");

    public MFXDatePicker() {
        this(Locale.getDefault());
    }

    public MFXDatePicker(Locale locale) {
        this(locale, YearMonth.now());
    }

    public MFXDatePicker(Locale locale, YearMonth startingYearMonth) {
        this.setLocale(locale);
        this.startingYearMonth = startingYearMonth;
        this.executor = new ReusableScheduledExecutor(Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }));
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-date-picker");
        this.setPrefWidth(200.0);
        this.setFloatMode(FloatMode.DISABLED);
        this.showing.addListener(invalidated -> this.pseudoClassStateChanged(POPUP_OPEN_PSEUDO_CLASS, this.showing.get()));
        this.defaultCellFactory();
        this.defaultConverters();
        this.defaultIcon();
    }

    public void defaultCellFactory() {
        this.setCellFactory(date -> new MFXDateCell(this, (LocalDate)date));
    }

    public void defaultConverters() {
        this.setConverterSupplier(() -> new DateStringConverter(FormatStyle.MEDIUM));
        this.setMonthConverterSupplier(() -> new MonthStringConverter(this.getLocale(), TextStyle.FULL));
        this.setDayOfWeekConverterSupplier(() -> new DayOfWeekStringConverter(this.getLocale(), TextStyle.SHORT));
    }

    public void defaultIcon() {
        MFXFontIcon calendar = new MFXFontIcon("mfx-calendar-alt-semi-dark", 20.0);
        calendar.getStyleClass().add((Object)"icon");
        MFXIconWrapper wrapped = new MFXIconWrapper((Node)calendar, 30.0);
        wrapped.rippleGeneratorBehavior(event -> {
            if (event == null) {
                return PositionBean.of(wrapped.getSize() / 2.0, wrapped.getSize() / 2.0);
            }
            return PositionBean.of(event.getX(), event.getY());
        });
        NodeUtils.makeRegionCircular((Region)wrapped);
        this.setTrailingIcon((Node)wrapped);
    }

    public void show() {
        this.setShowing(true);
    }

    public void hide() {
        this.setShowing(false);
    }

    public void commit(String text) {
        if (this.getOnCommit() != null) {
            this.getOnCommit().accept(text);
        }
    }

    public void cancel(String text) {
        if (this.getOnCancel() != null) {
            this.getOnCancel().accept(text);
        }
    }

    public void startCurrentDayUpdater() {
        long midnight = LocalDateTime.now().until(LocalDate.now().plusDays(1L).atStartOfDay(), ChronoUnit.MINUTES);
        this.executor.scheduleAtFixedRate(this::updateCurrentDate, midnight, TimeUnit.DAYS.toMinutes(1L), TimeUnit.MINUTES);
    }

    public void stopCurrentDayUpdater() {
        this.executor.cancelNow();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXDatePickerSkin(this, this.boundField);
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    private void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    public Alignment getPopupAlignment() {
        return (Alignment)this.popupAlignment.get();
    }

    public ObjectProperty<Alignment> popupAlignmentProperty() {
        return this.popupAlignment;
    }

    public void setPopupAlignment(Alignment popupAlignment) {
        this.popupAlignment.set((Object)popupAlignment);
    }

    public double getPopupOffsetX() {
        return this.popupOffsetX.get();
    }

    public DoubleProperty popupOffsetXProperty() {
        return this.popupOffsetX;
    }

    public void setPopupOffsetX(double popupOffsetX) {
        this.popupOffsetX.set(popupOffsetX);
    }

    public double getPopupOffsetY() {
        return this.popupOffsetY.get();
    }

    public DoubleProperty popupOffsetYProperty() {
        return this.popupOffsetY;
    }

    public void setPopupOffsetY(double popupOffsetY) {
        this.popupOffsetY.set(popupOffsetY);
    }

    public Locale getLocale() {
        return (Locale)this.locale.get();
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale.set((Object)locale);
    }

    public LocalDate getValue() {
        return (LocalDate)this.value.get();
    }

    public ObjectProperty<LocalDate> valueProperty() {
        return this.value;
    }

    public void setValue(LocalDate value) {
        this.value.set((Object)value);
    }

    public Supplier<StringConverter<LocalDate>> getConverterSupplier() {
        return (Supplier)this.converterSupplier.get();
    }

    public SupplierProperty<StringConverter<LocalDate>> converterSupplierProperty() {
        return this.converterSupplier;
    }

    public void setConverterSupplier(Supplier<StringConverter<LocalDate>> converterSupplier) {
        this.converterSupplier.set(converterSupplier);
    }

    public Supplier<StringConverter<Month>> getMonthConverterSupplier() {
        return (Supplier)this.monthConverterSupplier.get();
    }

    public SupplierProperty<StringConverter<Month>> monthConverterSupplierProperty() {
        return this.monthConverterSupplier;
    }

    public void setMonthConverterSupplier(Supplier<StringConverter<Month>> monthConverterSupplier) {
        this.monthConverterSupplier.set(monthConverterSupplier);
    }

    public Supplier<StringConverter<DayOfWeek>> getDayOfWeekConverterSupplier() {
        return (Supplier)this.dayOfWeekConverterSupplier.get();
    }

    public SupplierProperty<StringConverter<DayOfWeek>> dayOfWeekConverterSupplierProperty() {
        return this.dayOfWeekConverterSupplier;
    }

    public void setDayOfWeekConverterSupplier(Supplier<StringConverter<DayOfWeek>> dayOfWeekConverterSupplier) {
        this.dayOfWeekConverterSupplier.set(dayOfWeekConverterSupplier);
    }

    public Consumer<String> getOnCommit() {
        return (Consumer)this.onCommit.get();
    }

    public ConsumerProperty<String> onCommitProperty() {
        return this.onCommit;
    }

    public void setOnCommit(Consumer<String> onCommit) {
        this.onCommit.set(onCommit);
    }

    public Consumer<String> getOnCancel() {
        return (Consumer)this.onCancel.get();
    }

    public ConsumerProperty<String> onCancelProperty() {
        return this.onCancel;
    }

    public void setOnCancel(Consumer<String> onCancel) {
        this.onCancel.set(onCancel);
    }

    public Function<LocalDate, MFXDateCell> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    public ObjectProperty<Function<LocalDate, MFXDateCell>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public void setCellFactory(Function<LocalDate, MFXDateCell> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    public LocalDate getCurrentDate() {
        return (LocalDate)this.currentDate.get();
    }

    public ReadOnlyObjectProperty<LocalDate> currentDateProperty() {
        return this.currentDate.getReadOnlyProperty();
    }

    public void updateCurrentDate() {
        this.currentDate.set((Object)LocalDate.now());
    }

    public NumberRange<Integer> getYearsRange() {
        return (NumberRange)this.yearsRange.get();
    }

    public NumberRangeProperty<Integer> yearsRangeProperty() {
        return this.yearsRange;
    }

    public void setYearsRange(NumberRange<Integer> yearsRange) {
        this.yearsRange.set(yearsRange);
    }

    public BiFunction<Locale, YearMonth, Integer[][]> getGridAlgorithm() {
        return (BiFunction)this.gridAlgorithm.get();
    }

    public BiFunctionProperty<Locale, YearMonth, Integer[][]> gridAlgorithmProperty() {
        return this.gridAlgorithm;
    }

    public void setGridAlgorithm(BiFunction<Locale, YearMonth, Integer[][]> gridAlgorithm) {
        this.gridAlgorithm.set(gridAlgorithm);
    }

    public YearMonth getStartingYearMonth() {
        return this.startingYearMonth;
    }

    public void setStartingYearMonth(YearMonth startingYearMonth) {
        this.startingYearMonth = startingYearMonth;
    }

    public boolean isClosePopupOnChange() {
        return this.closePopupOnChange;
    }

    public void setClosePopupOnChange(boolean closePopupOnChange) {
        this.closePopupOnChange = closePopupOnChange;
    }
}

