/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.MFXTableView;
import io.github.palexdev.materialfx.skins.MFXPaginatedTableViewSkin;
import io.github.palexdev.materialfx.utils.NumberUtils;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.Skin;
import javafx.scene.input.ScrollEvent;

public class MFXPaginatedTableView<T>
extends MFXTableView<T> {
    private final String STYLE_CLASS = "mfx-paginated-table-view";
    private final IntegerProperty currentPage = new SimpleIntegerProperty(1){

        public void set(int newValue) {
            int number = NumberUtils.clamp(newValue, 1, MFXPaginatedTableView.this.getMaxPage());
            super.set(number);
        }
    };
    private final ReadOnlyIntegerWrapper maxPage = new ReadOnlyIntegerWrapper();
    private final IntegerProperty pagesToShow = new SimpleIntegerProperty(9);
    private final IntegerProperty rowsPerPage = new SimpleIntegerProperty(5);

    public MFXPaginatedTableView() {
        this(FXCollections.observableArrayList());
    }

    public MFXPaginatedTableView(ObservableList<T> items) {
        super(items);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-paginated-table-view");
        this.rowsFlow.getVBar().visibleProperty().unbind();
        this.rowsFlow.getHBar().visibleProperty().unbind();
        this.rowsFlow.getVBar().setVisible(false);
        this.rowsFlow.getHBar().setVisible(false);
        this.addEventFilter(ScrollEvent.ANY, Event::consume);
        this.getTransformableList().addListener(invalidated -> this.updateMaxPages());
        this.getTransformableList().predicateProperty().addListener(invalidated -> {
            this.updateMaxPages();
            this.setCurrentPage(1);
            this.goToPage(1);
        });
        this.updateMaxPages();
        this.currentPageProperty().addListener(invalidated -> this.goToPage(this.getCurrentPage()));
    }

    public void goToPage(int index) {
        int page = NumberUtils.clamp(index, 1, this.getMaxPage());
        double pos = (double)((page - 1) * this.getRowsPerPage()) * this.rowsFlow.getCellHeight();
        this.rowsFlow.getVBar().setValue(pos);
    }

    private void updateMaxPages() {
        int size = this.getTransformableList().size();
        int rowsPerPage = this.getRowsPerPage();
        int max = (int)Math.ceil((double)size / (double)rowsPerPage);
        this.setMaxPage(max);
    }

    @Override
    public void scrollBy(double pixels) {
        throw new UnsupportedOperationException("The paginated table view cannot scroll ny pixels");
    }

    @Override
    public void scrollTo(int index) {
        this.goToPage(index);
    }

    @Override
    public void scrollToFirst() {
        this.goToPage(1);
    }

    @Override
    public void scrollToLast() {
        this.goToPage(this.getMaxPage());
    }

    @Override
    public void scrollToPixel(double pixel) {
        throw new UnsupportedOperationException("The paginated table view cannot scroll to pixel");
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXPaginatedTableViewSkin(this, this.rowsFlow);
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage.set(currentPage);
    }

    public int getMaxPage() {
        return this.maxPage.get();
    }

    public ReadOnlyIntegerProperty maxPageProperty() {
        return this.maxPage.getReadOnlyProperty();
    }

    protected void setMaxPage(int maxPage) {
        this.maxPage.set(maxPage);
    }

    public int getPagesToShow() {
        return this.pagesToShow.get();
    }

    public IntegerProperty pagesToShowProperty() {
        return this.pagesToShow;
    }

    public void setPagesToShow(int pagesToShow) {
        this.pagesToShow.set(pagesToShow);
    }

    public int getRowsPerPage() {
        return this.rowsPerPage.get();
    }

    public IntegerProperty rowsPerPageProperty() {
        return this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage.set(rowsPerPage);
    }
}

