/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.skins.MFXProgressBarSkin;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Skin;

public class MFXProgressBar
extends ProgressBar {
    private static final StyleablePropertyFactory<MFXProgressBar> FACTORY = new StyleablePropertyFactory(ProgressBar.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-progress-bar";
    private final String STYLESHEETS = MFXResourcesLoader.load("css/MFXProgressBar.css");
    private final ObservableList<NumberRange<Double>> ranges1 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges2 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges3 = FXCollections.observableArrayList();
    protected final PseudoClass RANGE1_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range1");
    protected final PseudoClass RANGE2_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range2");
    protected final PseudoClass RANGE3_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range3");
    private final StyleableDoubleProperty animationSpeed = new SimpleStyleableDoubleProperty(StyleableProperties.ANIMATION_SPEED, (Object)this, "animationSpeed", Double.valueOf(1.0));

    public MFXProgressBar() {
        this.initialize();
    }

    public MFXProgressBar(double progress) {
        super(progress);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-progress-bar");
        this.setPrefWidth(200.0);
        this.addListeners();
    }

    private void addListeners() {
        this.ranges1.addListener(c -> this.handlePseudoClasses());
        this.ranges2.addListener(c -> this.handlePseudoClasses());
        this.ranges3.addListener(c -> this.handlePseudoClasses());
        this.progressProperty().addListener((observable, oldValue, newValue) -> this.handlePseudoClasses());
    }

    private void handlePseudoClasses() {
        double val = this.getProgress();
        if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE1_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges1)) {
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE2_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges2)) {
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE3_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges3)) {
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
        }
    }

    public ObservableList<NumberRange<Double>> getRanges1() {
        return this.ranges1;
    }

    public ObservableList<NumberRange<Double>> getRanges2() {
        return this.ranges2;
    }

    public ObservableList<NumberRange<Double>> getRanges3() {
        return this.ranges3;
    }

    public double getAnimationSpeed() {
        return this.animationSpeed.get();
    }

    public StyleableDoubleProperty animationSpeedProperty() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(double animationSpeed) {
        this.animationSpeed.set(animationSpeed);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXProgressBarSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXProgressBar.getClassCssMetaData();
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEETS;
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXProgressBar, Number> ANIMATION_SPEED;

        private StyleableProperties() {
        }

        static {
            ANIMATION_SPEED = FACTORY.createSizeCssMetaData("-mfx-animation-speed", MFXProgressBar::animationSpeedProperty, (Number)1.0);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(ProgressBar.getClassCssMetaData(), ANIMATION_SPEED);
        }
    }
}

