/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.base.AbstractMFXToggleNode;
import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import io.github.palexdev.materialfx.factories.RippleClipTypeFactory;
import io.github.palexdev.materialfx.skins.MFXRectangleToggleNodeSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Skin;

public class MFXRectangleToggleNode
extends AbstractMFXToggleNode {
    private final String STYLE_CLASS = "mfx-rectangle-toggle-node";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXRectangleToggleNode.css");
    private final ObjectProperty<RippleClipTypeFactory> rippleClipTypeFactory = new SimpleObjectProperty();

    public MFXRectangleToggleNode() {
        this("");
    }

    public MFXRectangleToggleNode(String text) {
        this(text, null);
    }

    public MFXRectangleToggleNode(String text, Node leadingIcon) {
        this(text, leadingIcon, null);
    }

    public MFXRectangleToggleNode(String text, Node leadingIcon, Node trailingIcon) {
        super(text, null);
        this.setLabelLeadingIcon(leadingIcon);
        this.setLabelTrailingIcon(trailingIcon);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-rectangle-toggle-node");
        this.setRippleClipTypeFactory(new RippleClipTypeFactory(RippleClipType.ROUNDED_RECTANGLE).setArcs(15.0));
    }

    public RippleClipTypeFactory getRippleClipTypeFactory() {
        return (RippleClipTypeFactory)this.rippleClipTypeFactory.get();
    }

    public ObjectProperty<RippleClipTypeFactory> rippleClipTypeFactoryProperty() {
        return this.rippleClipTypeFactory;
    }

    public void setRippleClipTypeFactory(RippleClipTypeFactory rippleClipTypeFactory) {
        this.rippleClipTypeFactory.set((Object)rippleClipTypeFactory);
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXRectangleToggleNodeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }
}

