/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.enums.NotificationState;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.utils.StringUtils;
import java.time.Instant;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Region;

public class MFXSimpleNotification
implements INotification {
    private Region content;
    private final ObjectProperty<NotificationState> state = new SimpleObjectProperty((Object)NotificationState.UNREAD);
    private final long createdTime;
    private Function<Long, String> timeToStringConverter = StringUtils::timeToHumanReadable;
    private BiConsumer<Long, String> onUpdate = (elapsedLong, elapsedString) -> {};

    protected MFXSimpleNotification() {
        this((Region)new AnchorPane());
    }

    public MFXSimpleNotification(Region content) {
        this.createdTime = Instant.now().getEpochSecond();
        if (content == null) {
            throw new IllegalArgumentException("Content cannot be null!");
        }
        this.content = content;
    }

    @Override
    public Region getContent() {
        return this.content;
    }

    protected void setContent(Region content) {
        this.content = content;
    }

    @Override
    public NotificationState getState() {
        return (NotificationState)((Object)this.state.get());
    }

    @Override
    public ObjectProperty<NotificationState> notificationStateProperty() {
        return this.state;
    }

    @Override
    public void setNotificationState(NotificationState state) {
        this.state.set((Object)state);
    }

    @Override
    public long getTime() {
        return this.createdTime;
    }

    @Override
    public long getElapsedTime() {
        return Instant.now().getEpochSecond() - this.createdTime;
    }

    @Override
    public Function<Long, String> getTimeToStringConverter() {
        return this.timeToStringConverter;
    }

    @Override
    public void setTimeToStringConverter(Function<Long, String> converter) {
        this.timeToStringConverter = converter;
    }

    @Override
    public void updateElapsed() {
        long elapsedTime = this.getElapsedTime();
        this.onUpdate.accept(elapsedTime, this.timeToStringConverter.apply(elapsedTime));
    }

    @Override
    public void setOnUpdateElapsed(BiConsumer<Long, String> elapsedConsumer) {
        this.onUpdate = elapsedConsumer;
    }

    public static class Builder {
        private final MFXSimpleNotification notification = new MFXSimpleNotification();

        protected Builder() {
        }

        public static Builder build() {
            return new Builder();
        }

        public Builder setContent(Region content) {
            if (content == null) {
                throw new IllegalArgumentException("Content cannot be null!");
            }
            this.notification.setContent(content);
            return this;
        }

        public Builder setState(NotificationState state) {
            this.notification.setNotificationState(state);
            return this;
        }

        public Builder setTimeToStringConverter(Function<Long, String> converter) {
            this.notification.setTimeToStringConverter(converter);
            return this;
        }

        public Builder setOnUpdateElapsed(BiConsumer<Long, String> elapsedConsumer) {
            this.notification.setOnUpdateElapsed(elapsedConsumer);
            return this;
        }

        public MFXSimpleNotification get() {
            return this.notification;
        }
    }
}

