/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.enums.StepperToggleState;
import io.github.palexdev.materialfx.enums.TextPosition;
import io.github.palexdev.materialfx.skins.MFXStepperToggleSkin;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class MFXStepperToggle
extends Control
implements Validated {
    private static final StyleablePropertyFactory<MFXStepperToggle> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-stepper-toggle";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXStepperToggle.css");
    private final MFXValidator validator = new MFXValidator();
    private final BooleanProperty showErrorIcon = new SimpleBooleanProperty(true);
    private Node content;
    private final StringProperty text = new SimpleStringProperty();
    private final ObjectProperty<Node> icon = new SimpleObjectProperty();
    private final ObjectProperty<StepperToggleState> state = new SimpleObjectProperty((Object)StepperToggleState.NONE);
    protected static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    protected static final PseudoClass COMPLETED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"completed");
    private final StyleableDoubleProperty labelTextGap = new SimpleStyleableDoubleProperty(StyleableProperties.LABEL_TEXT_GAP, (Object)this, "textGap", Double.valueOf(10.0));
    private final StyleableObjectProperty<TextPosition> textPosition = new SimpleStyleableObjectProperty(StyleableProperties.TEXT_POSITION, (Object)this, "textPosition", (Object)TextPosition.BOTTOM);
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", Double.valueOf(22.0));
    private final StyleableDoubleProperty strokeWidth = new SimpleStyleableDoubleProperty(StyleableProperties.STROKE_WIDTH, (Object)this, "strokeWidth", Double.valueOf(2.0));

    public MFXStepperToggle() {
        this("", null);
    }

    public MFXStepperToggle(String text) {
        this(text, null);
    }

    public MFXStepperToggle(String text, Node icon) {
        this(text, icon, null);
    }

    public MFXStepperToggle(String text, Node icon, Node content) {
        this.setText(text);
        this.setIcon(icon);
        this.content = content;
        this.initialize();
    }

    @Override
    public MFXValidator getValidator() {
        return this.validator;
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"mfx-stepper-toggle"});
        this.addListeners();
    }

    private void addListeners() {
        this.state.addListener(invalidated -> this.fireEvent(new MFXStepperToggleEvent(MFXStepperToggleEvent.STATE_CHANGED, (StepperToggleState)((Object)((Object)this.state.get())))));
        this.state.addListener((observable, oldValue, newValue) -> {
            this.resetPseudoClass();
            switch (newValue) {
                case SELECTED: {
                    this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, true);
                    break;
                }
                case COMPLETED: {
                    this.pseudoClassStateChanged(COMPLETED_PSEUDO_CLASS, true);
                    break;
                }
                case ERROR: {
                    this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, true);
                    break;
                }
                default: {
                    this.resetPseudoClass();
                }
            }
        });
    }

    private void resetPseudoClass() {
        this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, false);
        this.pseudoClassStateChanged(COMPLETED_PSEUDO_CLASS, false);
        this.pseudoClassStateChanged(INVALID_PSEUDO_CLASS, false);
    }

    public Bounds getGraphicBounds() {
        Node node = this.lookup("#circle");
        return node != null ? node.getBoundsInParent() : null;
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content = content;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public Node getIcon() {
        return (Node)this.icon.get();
    }

    public ObjectProperty<Node> iconProperty() {
        return this.icon;
    }

    public void setIcon(Node icon) {
        this.icon.set((Object)icon);
    }

    public StepperToggleState getState() {
        return (StepperToggleState)((Object)this.state.get());
    }

    public ObjectProperty<StepperToggleState> stateProperty() {
        return this.state;
    }

    public void setState(StepperToggleState state) {
        this.state.set((Object)state);
    }

    public boolean isShowErrorIcon() {
        return this.showErrorIcon.get();
    }

    public BooleanProperty showErrorIconProperty() {
        return this.showErrorIcon;
    }

    public void setShowErrorIcon(boolean showErrorIcon) {
        this.showErrorIcon.set(showErrorIcon);
    }

    public double getLabelTextGap() {
        return this.labelTextGap.get();
    }

    public StyleableDoubleProperty labelTextGapProperty() {
        return this.labelTextGap;
    }

    public void setLabelTextGap(double labelTextGap) {
        this.labelTextGap.set(labelTextGap);
    }

    public TextPosition getTextPosition() {
        return (TextPosition)((Object)this.textPosition.get());
    }

    public StyleableObjectProperty<TextPosition> textPositionProperty() {
        return this.textPosition;
    }

    public void setTextPosition(TextPosition textPosition) {
        this.textPosition.set((Object)textPosition);
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public double getStrokeWidth() {
        return this.strokeWidth.get();
    }

    public StyleableDoubleProperty strokeWidthProperty() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(double strokeWidth) {
        this.strokeWidth.set(strokeWidth);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXStepperToggleSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXStepperToggle.getControlCssMetaDataList();
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXStepperToggle, Number> LABEL_TEXT_GAP;
        private static final CssMetaData<MFXStepperToggle, TextPosition> TEXT_POSITION;
        private static final CssMetaData<MFXStepperToggle, Number> SIZE;
        private static final CssMetaData<MFXStepperToggle, Number> STROKE_WIDTH;

        private StyleableProperties() {
        }

        static {
            LABEL_TEXT_GAP = FACTORY.createSizeCssMetaData("-mfx-label-text-gap", MFXStepperToggle::labelTextGapProperty, (Number)10.0);
            TEXT_POSITION = FACTORY.createEnumCssMetaData(TextPosition.class, "-mfx-text-position", MFXStepperToggle::textPositionProperty, (Enum)TextPosition.BOTTOM);
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXStepperToggle::sizeProperty, (Number)22.0);
            STROKE_WIDTH = FACTORY.createSizeCssMetaData("-mfx-stroke-width", MFXStepperToggle::strokeWidthProperty, (Number)2.0);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Control.getClassCssMetaData(), LABEL_TEXT_GAP, TEXT_POSITION, SIZE, STROKE_WIDTH);
        }
    }

    public static class MFXStepperToggleEvent
    extends Event {
        private StepperToggleState state;
        public static final EventType<MFXStepperToggleEvent> STATE_CHANGED = new EventType(ANY, "STATE_CHANGED");

        public MFXStepperToggleEvent(EventType<? extends Event> eventType) {
            super(eventType);
        }

        public MFXStepperToggleEvent(EventType<? extends Event> eventType, StepperToggleState state) {
            super(eventType);
            this.state = state;
        }

        public StepperToggleState getState() {
            return this.state;
        }
    }
}

