/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTableView;
import io.github.palexdev.materialfx.controls.cell.MFXTableRowCell;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.virtualizedfx.cell.Cell;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;

public class MFXTableRow<T>
extends HBox
implements Cell<T> {
    private final String STYLE_CLASS = "mfx-table-row";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXTableView.css");
    private final MFXTableView<T> tableView;
    private final ObservableList<MFXTableRowCell<T, ?>> cells = FXCollections.observableArrayList();
    private final ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper();
    private final ReadOnlyObjectWrapper<T> data = new ReadOnlyObjectWrapper();
    protected final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");

    public MFXTableRow(MFXTableView<T> tableView, T data) {
        this.tableView = tableView;
        this.setData(data);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setPrefHeight(32.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.initialize();
        this.buildCells();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-table-row");
        this.setBehavior();
        this.setupRippleGenerator();
    }

    private void setBehavior() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.tableView.getSelectionModel().getSelection().containsKey((Object)this.getIndex()), (Observable[])new Observable[]{this.tableView.getSelectionModel().selectionProperty(), this.index}));
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, this::updateSelection);
    }

    protected void setupRippleGenerator() {
        this.rippleGenerator.setManaged(false);
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        this.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                this.rippleGenerator.generateRipple((MouseEvent)event);
            }
        });
    }

    public void updateRow() {
        T data = this.getData();
        if (data == null) {
            return;
        }
        this.updateRow(data);
    }

    protected void updateRow(T data) {
        if (this.cells.isEmpty()) {
            this.buildCells();
        } else {
            this.updateCells(data);
        }
    }

    protected void updateCells(T data) {
        this.cells.forEach(cell -> cell.update(data));
    }

    public void buildCells() {
        T data = this.getData();
        if (data == null) {
            return;
        }
        if (!this.cells.isEmpty()) {
            this.cells.clear();
        }
        ObservableList<MFXTableColumn<T>> columns = this.tableView.getTableColumns();
        for (MFXTableColumn column : columns) {
            MFXTableRowCell<T, ?> cell = column.getRowCellFactory().apply(data);
            cell.update(data);
            this.cells.add(cell);
        }
        this.updateChildren((List<MFXTableRowCell<T, ?>>)this.cells);
    }

    private void updateChildren(List<MFXTableRowCell<T, ?>> children) {
        LinkedList finalList = new LinkedList(children);
        finalList.add(0, (MFXTableRowCell<T, ?>)((Object)this.rippleGenerator));
        this.getChildren().setAll(finalList);
    }

    private void updateSelection(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        int index = this.getIndex();
        if (event.isControlDown()) {
            if (this.isSelected()) {
                this.tableView.getSelectionModel().deselectIndex(index);
            } else {
                this.tableView.getSelectionModel().selectIndex(index);
            }
            return;
        }
        if (event.isShiftDown()) {
            this.tableView.getSelectionModel().expandSelection(index);
            return;
        }
        this.tableView.getSelectionModel().replaceSelection(index);
    }

    public Node getNode() {
        return this;
    }

    public void updateItem(T data) {
        this.setData(data);
        this.updateRow(data);
    }

    public void updateIndex(int index) {
        this.setIndex(this.tableView.getTransformableList().viewToSource(index));
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public ObservableList<MFXTableRowCell<T, ?>> getCells() {
        return FXCollections.unmodifiableObservableList(this.cells);
    }

    public int getIndex() {
        return this.index.get();
    }

    public ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    protected void setIndex(int index) {
        this.index.set(index);
    }

    public T getData() {
        return (T)this.data.get();
    }

    public ReadOnlyObjectProperty<T> dataProperty() {
        return this.data.getReadOnlyProperty();
    }

    protected void setData(T data) {
        this.data.set(data);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    protected void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

