/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.base;

import io.github.palexdev.materialfx.controls.MFXTreeItem;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;

public abstract class AbstractMFXTreeCell<T>
extends HBox {
    protected final ObjectProperty<? super Node> disclosureNode = new SimpleObjectProperty();
    private final DoubleProperty fixedCellSize = new SimpleDoubleProperty();
    private static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private final BooleanProperty selected = new SimpleBooleanProperty(false);

    public AbstractMFXTreeCell(AbstractMFXTreeItem<T> item) {
        this(item, 27.0);
    }

    public AbstractMFXTreeCell(AbstractMFXTreeItem<T> item, double fixedHeight) {
        this.fixedCellSize.set(fixedHeight);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.prefHeightProperty().bind((ObservableValue)this.fixedCellSize);
        this.initialize(item);
        this.render(item.getData());
    }

    private void initialize(AbstractMFXTreeItem<T> item) {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(5.0);
        this.addListeners();
        this.selected.bind((ObservableValue)item.selectedProperty());
    }

    private void addListeners() {
        this.selected.addListener(invalidate -> this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.selected.get()));
    }

    public double getFixedCellSize() {
        return this.fixedCellSize.get();
    }

    public DoubleProperty fixedCellSizeProperty() {
        return this.fixedCellSize;
    }

    public void setFixedCellSize(double fixedCellSize) {
        this.fixedCellSize.set(fixedCellSize);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    protected abstract void defaultDisclosureNode();

    public abstract Node getDisclosureNode();

    public abstract <N extends Node> void setDisclosureNode(N var1);

    protected abstract void render(T var1);

    public abstract void updateCell(MFXTreeItem<T> var1);
}

