/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.MFXCheckTreeItem;
import io.github.palexdev.materialfx.controls.MFXCheckbox;
import io.github.palexdev.materialfx.controls.cell.MFXSimpleTreeCell;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;

public class MFXCheckTreeCell<T>
extends MFXSimpleTreeCell<T> {
    private final String STYLE_CLASS = "mfx-check-tree-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXCheckTreeCell.css");
    private final MFXCheckbox checkbox;
    private static final PseudoClass CHECKED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"checked");
    private static final PseudoClass INDETERMINATE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"indeterminate");
    private final BooleanProperty checked = new SimpleBooleanProperty(false);
    private final BooleanProperty indeterminate = new SimpleBooleanProperty(false);

    public MFXCheckTreeCell(MFXCheckTreeItem<T> item) {
        super(item);
        this.checkbox = new MFXCheckbox("");
        this.getChildren().add(1, (Object)this.checkbox);
        this.initialize(item);
    }

    public MFXCheckTreeCell(MFXCheckTreeItem<T> item, double fixedHeight) {
        super(item, fixedHeight);
        this.checkbox = new MFXCheckbox("");
        this.getChildren().add(1, (Object)this.checkbox);
        this.initialize(item);
    }

    private void initialize(MFXCheckTreeItem<T> item) {
        this.getStyleClass().add((Object)"mfx-check-tree-cell");
        this.setFixedCellSize(32.0);
        this.addListeners();
        this.checked.bind((ObservableValue)item.checkedProperty());
        this.indeterminate.bind((ObservableValue)item.indeterminateProperty());
    }

    private void addListeners() {
        this.checked.addListener(invalidate -> this.pseudoClassStateChanged(CHECKED_PSEUDO_CLASS, this.checked.get()));
        this.checked.addListener((observable, oldValue, newValue) -> this.checkbox.setSelected((boolean)newValue));
        this.indeterminate.addListener(invalidate -> this.pseudoClassStateChanged(INDETERMINATE_PSEUDO_CLASS, this.indeterminate.get()));
        this.indeterminate.addListener((observable, oldValue, newValue) -> this.checkbox.setIndeterminate((boolean)newValue));
    }

    public MFXCheckbox getCheckbox() {
        return this.checkbox;
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }
}

