/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.base.MFXCombo;
import io.github.palexdev.virtualizedfx.cell.Cell;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

public class MFXComboBoxCell<T>
extends HBox
implements Cell<T> {
    private final String STYLE_CLASS = "mfx-combo-box-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXComboBoxCell.css");
    protected final ReadOnlyObjectWrapper<T> data = new ReadOnlyObjectWrapper();
    protected final ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper();
    protected final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    protected final MFXCombo<T> comboBox;
    private final Label label;

    public MFXComboBoxCell(MFXCombo<T> combo, T data) {
        this.comboBox = combo;
        this.setPrefHeight(32.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(5.0);
        if (!(data instanceof Node)) {
            this.label = new Label();
            this.label.getStyleClass().add((Object)"data-label");
            this.label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                StringConverter converter = combo.getConverter();
                return converter != null ? converter.toString(this.getData()) : this.getData().toString();
            }, (Observable[])new Observable[]{this.dataProperty(), combo.converterProperty()}));
        } else {
            this.label = null;
        }
        this.initialize();
    }

    protected void initialize() {
        this.getStyleClass().add((Object)"mfx-combo-box-cell");
        this.setBehavior();
        this.render(this.getData());
    }

    protected void setBehavior() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(this.SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.comboBox.getSelectionModel().getSelectedIndex() == this.index.get(), (Observable[])new Observable[]{this.comboBox.getSelectionModel().selectedIndexProperty(), this.index}));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this::updateSelection);
    }

    protected void render(T data) {
        if (data instanceof Node) {
            this.getChildren().setAll((Object[])new Node[]{(Node)data});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.label});
        }
    }

    protected void updateSelection(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        int index = this.getIndex();
        this.comboBox.getSelectionModel().selectIndex(index);
    }

    public Node getNode() {
        return this;
    }

    public void updateIndex(int index) {
        this.setIndex(index);
    }

    public void updateItem(T item) {
        this.setData(item);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public T getData() {
        return (T)this.data.get();
    }

    public ReadOnlyObjectProperty<T> dataProperty() {
        return this.data.getReadOnlyProperty();
    }

    protected void setData(T data) {
        this.data.set(data);
    }

    public int getIndex() {
        return this.index.get();
    }

    public ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    protected void setIndex(int index) {
        this.index.set(index);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    protected void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

