/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.MFXDatePicker;
import io.github.palexdev.virtualizedfx.cell.Cell;
import java.time.LocalDate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;

public class MFXDateCell
extends Label
implements Cell<LocalDate> {
    private final String STYLE_CLASS = "mfx-date-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXDateCell.css");
    private final MFXDatePicker datePicker;
    private final ReadOnlyObjectWrapper<LocalDate> date = new ReadOnlyObjectWrapper();
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    private final ReadOnlyBooleanWrapper current = new ReadOnlyBooleanWrapper();
    protected static final PseudoClass CURRENT_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"current");
    private boolean extra = false;
    protected static final PseudoClass EXTRA_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"extra");

    public MFXDateCell(MFXDatePicker datePicker, LocalDate date) {
        this.datePicker = datePicker;
        this.updateItem(date);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-date-cell");
        this.setAlignment(Pos.CENTER);
        this.setBehavior();
    }

    protected void setBehavior() {
        this.selected.addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.current.addListener((observable, oldValue, newValue) -> this.pseudoClassStateChanged(CURRENT_PSEUDO_CLASS, this.current.get()));
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.getDate() != null ? String.valueOf(this.getDate().getDayOfMonth()) : "", (Observable[])new Observable[]{this.dateProperty()}));
        this.visibleProperty().bind((ObservableValue)this.textProperty().isNotEmpty());
        this.selected.bind((ObservableValue)this.datePicker.valueProperty().isEqualTo(this.dateProperty()));
        this.current.bind((ObservableValue)this.datePicker.currentDateProperty().isEqualTo(this.dateProperty()));
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.datePicker.setValue(this.getDate()));
    }

    public void markAsExtra() {
        this.extra = true;
        this.pseudoClassStateChanged(EXTRA_PSEUDO_CLASS, true);
    }

    public void unmarkAsExtra() {
        this.extra = false;
        this.pseudoClassStateChanged(EXTRA_PSEUDO_CLASS, false);
    }

    public Node getNode() {
        return this;
    }

    public void updateItem(LocalDate date) {
        this.setDate(date);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public LocalDate getDate() {
        return (LocalDate)this.date.get();
    }

    public ReadOnlyObjectProperty<LocalDate> dateProperty() {
        return this.date.getReadOnlyProperty();
    }

    protected void setDate(LocalDate date) {
        this.date.set((Object)date);
    }

    public boolean isExtra() {
        return this.extra;
    }
}

