/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.controls.MFXCheckbox;
import io.github.palexdev.materialfx.controls.MFXNotificationCenter;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.virtualizedfx.cell.Cell;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class MFXNotificationCell
extends HBox
implements Cell<INotification> {
    private final String STYLE_CLASS = "mfx-notification-cell";
    private final MFXNotificationCenter notificationCenter;
    private final ReadOnlyObjectWrapper<INotification> notification = new ReadOnlyObjectWrapper();
    private final ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper();
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");
    protected final StackPane container;
    protected final MFXCheckbox checkbox;

    public MFXNotificationCell(MFXNotificationCenter notificationCenter, INotification notification) {
        this.notificationCenter = notificationCenter;
        this.setNotification(notification);
        this.setPrefHeight(80.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setAlignment(Pos.CENTER_LEFT);
        this.checkbox = new MFXCheckbox("");
        this.checkbox.setId("check");
        this.container = new StackPane(new Node[]{this.checkbox});
        this.container.setMinWidth(Double.NEGATIVE_INFINITY);
        this.container.setPrefWidth(0.0);
        this.container.setMaxWidth(Double.NEGATIVE_INFINITY);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.container.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.container.heightProperty());
        this.container.setClip((Node)clip);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-notification-cell");
        this.setBehavior();
        this.render(this.getNotification());
        if (this.notificationCenter.isSelectionMode()) {
            this.expand(true);
        }
    }

    protected void setBehavior() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(this.SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            boolean contained = this.notificationCenter.getSelectionModel().getSelection().containsKey((Object)this.getIndex());
            this.checkbox.setSelected(contained);
            return contained;
        }, (Observable[])new Observable[]{this.notificationCenter.getSelectionModel().selectionProperty(), this.index}));
        this.checkbox.selectedProperty().addListener((observable, oldValue, newValue) -> this.updateSelection((boolean)newValue));
        this.notificationCenter.selectionModeProperty().addListener((observable, oldValue, newValue) -> this.expand((boolean)newValue));
    }

    protected void render(INotification notification) {
        if (this.notificationCenter.isSelectionMode()) {
            this.checkbox.setOpacity(1.0);
            this.checkbox.setPrefWidth(45.0);
        }
        this.getChildren().setAll((Object[])new Node[]{this.container, notification.getContent()});
    }

    protected void updateSelection(boolean checked) {
        int index = this.getIndex();
        if (checked) {
            this.notificationCenter.getSelectionModel().selectIndex(index);
        } else {
            this.notificationCenter.getSelectionModel().deselectIndex(index);
        }
    }

    protected void expand(boolean selectionMode) {
        double opacity;
        double width = selectionMode ? 45.0 : 0.0;
        double d = opacity = selectionMode ? 1.0 : 0.0;
        if (this.notificationCenter.isAnimated()) {
            AnimationUtils.ParallelBuilder.build().add(AnimationUtils.KeyFrames.of(150.0, this.checkbox.opacityProperty(), Double.valueOf(opacity), Interpolators.EASE_OUT), AnimationUtils.KeyFrames.of(250.0, this.container.prefWidthProperty(), Double.valueOf(width), Interpolators.EASE_OUT_SINE)).getAnimation().play();
        } else {
            this.container.setPrefWidth(width);
            this.checkbox.setOpacity(opacity);
        }
        if (!selectionMode) {
            this.notificationCenter.getSelectionModel().clearSelection();
        }
    }

    public Node getNode() {
        return this;
    }

    public void updateItem(INotification notification) {
        this.setNotification(notification);
        this.render(notification);
    }

    public void updateIndex(int index) {
        this.setIndex(index);
    }

    public void afterLayout() {
        this.expand(this.notificationCenter.isSelectionMode());
    }

    public INotification getNotification() {
        return (INotification)this.notification.get();
    }

    public ReadOnlyObjectProperty<INotification> notificationProperty() {
        return this.notification.getReadOnlyProperty();
    }

    protected void setNotification(INotification notification) {
        this.notification.set((Object)notification);
    }

    public int getIndex() {
        return this.index.get();
    }

    protected ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    protected void setIndex(int index) {
        this.index.set(index);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    protected void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

