/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTreeItem;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeCell;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.font.MFXFontIcon;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;

public class MFXSimpleTreeCell<T>
extends AbstractMFXTreeCell<T> {
    private final String STYLE_CLASS = "mfx-tree-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXTreeCell.css");

    public MFXSimpleTreeCell(AbstractMFXTreeItem<T> item) {
        super(item);
        this.initialize();
    }

    public MFXSimpleTreeCell(AbstractMFXTreeItem<T> item, double fixedHeight) {
        super(item, fixedHeight);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-tree-cell");
        this.defaultDisclosureNode();
        this.getChildren().add(0, (Object)this.getDisclosureNode());
        this.disclosureNode.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.getChildren().set(0, (Object)((Node)newValue));
            }
        });
    }

    @Override
    protected void defaultDisclosureNode() {
        MFXIconWrapper disclosureNode = new MFXIconWrapper().defaultRippleGeneratorBehavior();
        disclosureNode.getStyleClass().setAll((Object[])new String[]{"disclosure-node"});
        disclosureNode.setSize(22.0);
        NodeUtils.makeRegionCircular((Region)disclosureNode, 9.5);
        this.setDisclosureNode(disclosureNode);
    }

    public MFXIconWrapper getDisclosureNode() {
        return (MFXIconWrapper)((Object)this.disclosureNode.get());
    }

    @Override
    public <N extends Node> void setDisclosureNode(N node) {
        this.disclosureNode.set(node);
    }

    @Override
    protected void render(T data) {
        if (data instanceof Node) {
            this.getChildren().add((Object)((Node)data));
        } else {
            Label label = new Label(data.toString());
            label.getStyleClass().add((Object)"data-label");
            this.getChildren().add((Object)label);
        }
    }

    @Override
    public void updateCell(MFXTreeItem<T> item) {
        MFXIconWrapper disclosureNode = this.getDisclosureNode();
        if (!item.getItems().isEmpty()) {
            MFXFontIcon icon = new MFXFontIcon("mfx-chevron-right", 12.5);
            icon.getStyleClass().add((Object)"disclosure-icon");
            disclosureNode.setIcon((Node)icon);
        } else {
            disclosureNode.removeIcon();
        }
        if (item.isStartExpanded()) {
            disclosureNode.setRotate(90.0);
        }
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }
}

