/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.MFXResourcesLoader;
import io.github.palexdev.materialfx.skins.MFXTableRowCellSkin;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.util.StringConverter;

public class MFXTableRowCell<T, E>
extends Labeled {
    private final String STYLE_CLASS = "mfx-table-row-cell";
    private final String STYLESHEET = MFXResourcesLoader.load("css/MFXTableView.css");
    private final Function<T, E> extractor;
    private final StringConverter<E> converter;
    private final ObjectProperty<Node> leadingGraphic = new SimpleObjectProperty();
    private final ObjectProperty<Node> trailingGraphic = new SimpleObjectProperty();

    public MFXTableRowCell(Function<T, E> extractor) {
        this(extractor, Objects::toString);
    }

    public MFXTableRowCell(Function<T, E> extractor, Function<E, String> converter) {
        this.extractor = extractor;
        this.converter = FunctionalStringConverter.to(converter);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-table-row-cell");
        this.setAlignment(Pos.CENTER_LEFT);
    }

    public void update(T item) {
        if (this.extractor == null) {
            return;
        }
        E data = this.extractor.apply(item);
        this.setText(this.converter.toString(data));
    }

    public double computePrefWidth(double height) {
        return super.computePrefWidth(height);
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXTableRowCellSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    public Node getLeadingGraphic() {
        return (Node)this.leadingGraphic.get();
    }

    public ObjectProperty<Node> leadingGraphicProperty() {
        return this.leadingGraphic;
    }

    public void setLeadingGraphic(Node leadingGraphic) {
        this.leadingGraphic.set((Object)leadingGraphic);
    }

    public Node getTrailingGraphic() {
        return (Node)this.trailingGraphic.get();
    }

    public ObjectProperty<Node> trailingGraphicProperty() {
        return this.trailingGraphic;
    }

    public void setTrailingGraphic(Node trailingGraphic) {
        this.trailingGraphic.set((Object)trailingGraphic);
    }
}

