/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.models.spinner;

import io.github.palexdev.materialfx.controls.models.spinner.NumberSpinnerModel;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import java.util.Objects;

public class DoubleSpinnerModel
extends NumberSpinnerModel<Double> {
    public DoubleSpinnerModel() {
        this(0.0);
    }

    public DoubleSpinnerModel(double initialValue) {
        this.setConverter(FunctionalStringConverter.converter(Double::parseDouble, Objects::toString));
        this.setDefaultValue(0.0);
        this.setMin(0.0);
        this.setMax(Double.MAX_VALUE);
        this.setIncrement(1.0);
        this.setValue(initialValue);
    }

    @Override
    public void next() {
        double newVal = (Double)this.getValue() + (Double)this.getIncrement();
        if (newVal > (Double)this.getMax()) {
            newVal = this.isWrapAround() ? (Double)this.getMin() : (Double)this.getMax();
        }
        this.setValue(newVal);
    }

    @Override
    public void previous() {
        double newVal = (Double)this.getValue() - (Double)this.getIncrement();
        if (newVal < (Double)this.getMin()) {
            newVal = this.isWrapAround() ? (Double)this.getMax() : (Double)this.getMin();
        }
        this.setValue(newVal);
    }
}

