/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.models.spinner;

import io.github.palexdev.materialfx.controls.models.spinner.NumberSpinnerModel;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import java.util.Objects;

public class IntegerSpinnerModel
extends NumberSpinnerModel<Integer> {
    public IntegerSpinnerModel() {
        this(0);
    }

    public IntegerSpinnerModel(int initialValue) {
        this.setConverter(FunctionalStringConverter.converter(Integer::parseInt, Objects::toString));
        this.setDefaultValue(0);
        this.setMin(0);
        this.setMax(Integer.MAX_VALUE);
        this.setIncrement(1);
        this.setValue(initialValue);
    }

    @Override
    public void next() {
        int newVal = (Integer)this.getValue() + (Integer)this.getIncrement();
        if (newVal > (Integer)this.getMax()) {
            newVal = this.isWrapAround() ? (Integer)this.getMin() : (Integer)this.getMax();
        }
        this.setValue(newVal);
    }

    @Override
    public void previous() {
        int newVal = (Integer)this.getValue() - (Integer)this.getIncrement();
        if (newVal < (Integer)this.getMin()) {
            newVal = this.isWrapAround() ? (Integer)this.getMax() : (Integer)this.getMin();
        }
        this.setValue(newVal);
    }
}

