/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.models.spinner;

import io.github.palexdev.materialfx.controls.models.spinner.AbstractSpinnerModel;
import io.github.palexdev.materialfx.utils.ListChangeProcessor;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import io.github.palexdev.virtualizedfx.beans.NumberRange;
import io.github.palexdev.virtualizedfx.utils.ListChangeHelper;
import java.util.ArrayList;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public class ListSpinnerModel<T>
extends AbstractSpinnerModel<T> {
    private final ListProperty<T> items = new SimpleListProperty();
    private int currentIndex = -1;
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty();
    private final IntegerProperty increment = new SimpleIntegerProperty();

    public ListSpinnerModel() {
        this(FXCollections.observableArrayList());
    }

    public ListSpinnerModel(ObservableList<T> items) {
        this.setConverter(FunctionalStringConverter.to(t -> t != null ? t.toString() : ""));
        this.setItems(items);
        this.setIncrement(1);
        this.items.addListener((observable, oldValue, newValue) -> {
            if (oldValue != newValue) {
                this.reset();
            }
        });
        this.items.addListener(this::updateCurrentIndex);
        if (!items.isEmpty()) {
            this.currentIndex = 0;
            this.setValue(items.get(this.currentIndex));
        }
    }

    private void updateCurrentIndex(ListChangeListener.Change<? extends T> change) {
        if (this.currentIndex == -1 && !change.getList().isEmpty()) {
            this.currentIndex = 0;
            this.setValue(change.getList().get(this.currentIndex));
            return;
        }
        if (change.getList().isEmpty()) {
            this.reset();
            return;
        }
        ListChangeHelper.Change c = ListChangeHelper.processChange(change, (NumberRange)NumberRange.of((Number)0, (Number)Integer.MAX_VALUE));
        ListChangeProcessor updater = new ListChangeProcessor(Set.of(Integer.valueOf(this.currentIndex)));
        c.processReplacement((replaced, removed) -> {
            Object value = this.items.get(this.currentIndex);
            this.setValue(value);
        });
        c.processAddition((from, to, added) -> {
            updater.computeAddition(added.size(), (int)from);
            ArrayList<Integer> indexes = new ArrayList<Integer>(updater.getIndexes());
            if (!indexes.isEmpty()) {
                this.currentIndex = (Integer)indexes.get(0);
                Object value = this.items.get(this.currentIndex);
                this.setValue(value);
            }
        });
        c.processRemoval((from, to, removed) -> {
            updater.computeRemoval((Set<Integer>)removed, (int)from);
            ArrayList<Integer> indexes = new ArrayList<Integer>(updater.getIndexes());
            if (!indexes.isEmpty()) {
                this.currentIndex = (Integer)indexes.get(0);
                Object value = this.items.get(this.currentIndex);
                this.setValue(value);
            }
        });
    }

    @Override
    public void next() {
        if (this.items.isEmpty()) {
            return;
        }
        int newIndex = this.currentIndex + this.getIncrement();
        if (newIndex > this.items.size() - 1) {
            newIndex = this.isWrapAround() ? 0 : this.items.size() - 1;
        }
        this.currentIndex = newIndex;
        this.setValue(this.items.get(newIndex));
    }

    @Override
    public void previous() {
        if (this.items.isEmpty()) {
            return;
        }
        int newIndex = this.currentIndex - this.getIncrement();
        if (newIndex < 0) {
            newIndex = this.isWrapAround() ? this.items.size() - 1 : 0;
        }
        this.currentIndex = newIndex;
        this.setValue(this.items.get(newIndex));
    }

    @Override
    public void reset() {
        super.reset();
        this.currentIndex = -1;
    }

    @Override
    public StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    @Override
    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    @Override
    public void setConverter(StringConverter<T> converter) {
        this.converter.set(converter);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ListProperty<T> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public int getIncrement() {
        return this.increment.get();
    }

    public IntegerProperty incrementProperty() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment.set(increment);
    }
}

