/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.dialogs;

import io.github.palexdev.materialfx.dialogs.AbstractMFXDialog;
import io.github.palexdev.materialfx.dialogs.MFXStageDialog;
import io.github.palexdev.materialfx.enums.ScrimPriority;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class MFXStageDialogBuilder {
    private final MFXStageDialog stageDialog;

    public MFXStageDialogBuilder() {
        this.stageDialog = new MFXStageDialog();
    }

    public MFXStageDialogBuilder(MFXStageDialog stageDialog) {
        this.stageDialog = stageDialog;
    }

    public static MFXStageDialogBuilder build() {
        return new MFXStageDialogBuilder();
    }

    public static MFXStageDialogBuilder build(MFXStageDialog stageDialog) {
        return new MFXStageDialogBuilder(stageDialog);
    }

    public MFXStageDialogBuilder setContent(AbstractMFXDialog content) {
        this.stageDialog.setContent(content);
        return this;
    }

    public MFXStageDialogBuilder setOwnerNode(Pane ownerNode) {
        this.stageDialog.setOwnerNode(ownerNode);
        return this;
    }

    public MFXStageDialogBuilder setCenterInOwnerNode(boolean centerInOwnerNode) {
        this.stageDialog.setCenterInOwnerNode(centerInOwnerNode);
        return this;
    }

    public MFXStageDialogBuilder setScrimOwner(boolean scrimOwner) {
        this.stageDialog.setScrimOwner(scrimOwner);
        return this;
    }

    public MFXStageDialogBuilder setScrimStrength(double scrimStrength) {
        this.stageDialog.setScrimStrength(scrimStrength);
        return this;
    }

    public MFXStageDialogBuilder setScrimPriority(ScrimPriority scrimPriority) {
        this.stageDialog.setScrimPriority(scrimPriority);
        return this;
    }

    public MFXStageDialogBuilder setDraggable(boolean draggable) {
        this.stageDialog.setDraggable(draggable);
        return this;
    }

    public MFXStageDialogBuilder setOverlayClose(boolean overlayClose) {
        this.stageDialog.setOverlayClose(overlayClose);
        return this;
    }

    public MFXStageDialogBuilder initModality(Modality modality) {
        this.stageDialog.initModality(modality);
        return this;
    }

    public MFXStageDialogBuilder initOwner(Window owner) {
        this.stageDialog.initOwner(owner);
        return this;
    }

    public MFXStageDialogBuilder setTitle(String title) {
        this.stageDialog.setTitle(title);
        return this;
    }

    public MFXStageDialogBuilder setAlwaysOnTop(boolean alwaysOnTop) {
        this.stageDialog.setAlwaysOnTop(alwaysOnTop);
        return this;
    }

    public MFXStageDialogBuilder setOnCloseRequest(EventHandler<WindowEvent> handler) {
        this.stageDialog.setOnCloseRequest(handler);
        return this;
    }

    public MFXStageDialogBuilder setOnShowing(EventHandler<WindowEvent> handler) {
        this.stageDialog.setOnShowing(handler);
        return this;
    }

    public MFXStageDialogBuilder setOnShown(EventHandler<WindowEvent> handler) {
        this.stageDialog.setOnShown(handler);
        return this;
    }

    public MFXStageDialogBuilder setOnHiding(EventHandler<WindowEvent> handler) {
        this.stageDialog.setOnHiding(handler);
        return this;
    }

    public MFXStageDialogBuilder setOnHidden(EventHandler<WindowEvent> handler) {
        this.stageDialog.setOnHidden(handler);
        return this;
    }

    public <T extends Event> MFXStageDialogBuilder addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.stageDialog.addEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> MFXStageDialogBuilder removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.stageDialog.removeEventHandler(eventType, eventHandler);
        return this;
    }

    public <T extends Event> MFXStageDialogBuilder addEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.stageDialog.addEventFilter(eventType, eventFilter);
        return this;
    }

    public <T extends Event> MFXStageDialogBuilder removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventFilter) {
        this.stageDialog.removeEventFilter(eventType, eventFilter);
        return this;
    }

    public MFXStageDialog get() {
        return this.stageDialog;
    }
}

