/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects;

import java.util.Arrays;
import javafx.scene.effect.DropShadow;
import javafx.scene.paint.Color;

public enum DepthLevel {
    LEVEL0(Color.rgb((int)0, (int)0, (int)0, (double)0.0), 0.0, 0.0, 0.0, 0.0),
    LEVEL1(Color.rgb((int)0, (int)0, (int)0, (double)0.2), 10.0, 0.12, -1.0, 2.0),
    LEVEL2(Color.rgb((int)0, (int)0, (int)0, (double)0.2), 15.0, 0.16, 0.0, 4.0),
    LEVEL3(Color.rgb((int)0, (int)0, (int)0, (double)0.2), 20.0, 0.19, 0.0, 6.0),
    LEVEL4(Color.rgb((int)0, (int)0, (int)0, (double)0.2), 25.0, 0.25, 0.0, 8.0),
    LEVEL5(Color.rgb((int)0, (int)0, (int)0, (double)0.2), 30.0, 0.3, 0.0, 10.0);

    private final Color color;
    private final double radius;
    private final double spread;
    private final double offsetX;
    private final double offsetY;
    private static final DepthLevel[] valuesArr;

    private DepthLevel(Color color, double radius, double spread, double offsetX, double offsetY) {
        this.color = color;
        this.radius = radius;
        this.spread = spread;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public Color getColor() {
        return this.color;
    }

    public double getRadius() {
        return this.radius;
    }

    public double getSpread() {
        return this.spread;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public DepthLevel next() {
        return valuesArr[(this.ordinal() + 1) % valuesArr.length];
    }

    public static DepthLevel from(DropShadow shadow) {
        return Arrays.stream(DepthLevel.values()).filter(depthLevel -> DepthLevel.levelEqualsShadow(depthLevel, shadow)).findFirst().orElse(null);
    }

    public static boolean levelEqualsShadow(DepthLevel level, DropShadow shadow) {
        return level.color.equals((Object)shadow.getColor()) && level.offsetX == shadow.getOffsetX() && level.offsetY == shadow.getOffsetY() && level.radius == shadow.getRadius() && level.spread == shadow.getSpread();
    }

    static {
        valuesArr = DepthLevel.values();
    }
}

