/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects;

import io.github.palexdev.materialfx.effects.DepthLevel;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.paint.Color;

public class MFXDepthManager {
    public static DropShadow shadowOf(Color color, double radius, double spread, double offsetX, double offsetY) {
        return new DropShadow(BlurType.GAUSSIAN, color, radius, spread, offsetX, offsetY);
    }

    public static DropShadow shadowOf(DepthLevel level) {
        return new DropShadow(BlurType.GAUSSIAN, level.getColor(), level.getRadius(), level.getSpread(), level.getOffsetX(), level.getOffsetY());
    }

    public static DropShadow shadowOf(DepthLevel level, int delta) {
        DepthLevel endLevel = level;
        for (int i = 0; i < delta; ++i) {
            endLevel = MFXDepthManager.nextLevel(endLevel);
        }
        return MFXDepthManager.shadowOf(endLevel);
    }

    private static DepthLevel nextLevel(DepthLevel startLevel) {
        return !startLevel.equals((Object)DepthLevel.LEVEL5) ? startLevel.next() : DepthLevel.LEVEL5;
    }
}

