/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects.ripple;

import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.effects.MFXDepthManager;
import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.factories.RippleClipTypeFactory;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

@Deprecated
public class RippleGenerator
extends Group {
    private final String STYLE_CLASS = "ripple-generator";
    private static final StyleablePropertyFactory<RippleGenerator> FACTORY = new StyleablePropertyFactory(Group.getClassCssMetaData());
    private final Region region;
    private RippleClipTypeFactory rippleClipTypeFactory = new RippleClipTypeFactory(RippleClipType.RECTANGLE);
    private DepthLevel level = null;
    private final StyleableObjectProperty<Paint> rippleColor = new SimpleStyleableObjectProperty(StyleableProperties.RIPPLE_COLOR, (Object)this, "rippleColor", (Object)Color.ROYALBLUE);
    private final StyleableDoubleProperty rippleRadius = new SimpleStyleableDoubleProperty(StyleableProperties.RIPPLE_RADIUS, (Object)this, "rippleRadius", Double.valueOf(10.0));
    private final StyleableBooleanProperty animateBackground = new SimpleStyleableBooleanProperty(StyleableProperties.ANIMATE_BACKGROUND, (Object)this, "animateBackground", true);
    private final ObjectProperty<Duration> inDuration = new SimpleObjectProperty((Object)Duration.millis((double)700.0));
    private final ObjectProperty<Duration> outDuration = new SimpleObjectProperty((Object)((Duration)this.inDuration.get()).divide(2.0));
    private double generatorCenterX = 0.0;
    private double generatorCenterY = 0.0;

    public RippleGenerator(Region region) {
        this.region = region;
        this.getStyleClass().add((Object)"ripple-generator");
        this.inDuration.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.outDuration.set((Object)newValue.divide(2.0));
            }
        });
        this.outDuration.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.inDuration.set((Object)newValue.multiply(2.0));
            }
        });
    }

    public RippleGenerator(Region region, DepthLevel shadowLevel) {
        this(region);
        this.level = shadowLevel;
    }

    public RippleGenerator(Region region, RippleClipTypeFactory factory) {
        this(region);
        this.rippleClipTypeFactory = factory;
    }

    public RippleGenerator(Region region, DepthLevel shadowLevel, RippleClipTypeFactory factory) {
        this(region, shadowLevel);
        this.rippleClipTypeFactory = factory;
    }

    public void createRipple() {
        Ripple ripple = new Ripple(this.generatorCenterX, this.generatorCenterY);
        this.getChildren().add((Object)ripple);
        Shape shape = this.rippleClipTypeFactory.build(this.region);
        if (this.animateBackground.get()) {
            shape.setFill((Paint)this.rippleColor.get());
            shape.setOpacity(0.0);
            this.getChildren().add(0, (Object)shape);
            KeyValue keyValueIn = new KeyValue((WritableValue)shape.opacityProperty(), (Object)0.3);
            KeyValue keyValueOut = new KeyValue((WritableValue)shape.opacityProperty(), (Object)0);
            KeyFrame keyFrameIn = new KeyFrame((Duration)this.inDuration.get(), new KeyValue[]{keyValueIn});
            KeyFrame keyFrameOut = new KeyFrame((Duration)this.outDuration.get(), new KeyValue[]{keyValueOut});
            ripple.inAnimation.getKeyFrames().add((Object)keyFrameIn);
            ripple.outAnimation.getKeyFrames().add((Object)keyFrameOut);
        }
        ripple.parallelTransition.setOnFinished(event -> this.getChildren().removeAll((Object[])new Node[]{ripple, shape}));
        ripple.parallelTransition.play();
    }

    public void setGeneratorCenterX(double generatorCenterX) {
        this.generatorCenterX = generatorCenterX;
    }

    public void setGeneratorCenterY(double generatorCenterY) {
        this.generatorCenterY = generatorCenterY;
    }

    public void setRippleClipTypeFactory(RippleClipTypeFactory rippleClipTypeFactory) {
        this.rippleClipTypeFactory = rippleClipTypeFactory;
    }

    public Paint getRippleColor() {
        return (Paint)this.rippleColor.get();
    }

    public final StyleableObjectProperty<Paint> rippleColorProperty() {
        return this.rippleColor;
    }

    public void setRippleColor(Paint rippleColor) {
        this.rippleColor.set((Object)rippleColor);
    }

    public double getRippleRadius() {
        return this.rippleRadius.get();
    }

    public StyleableDoubleProperty rippleRadiusProperty() {
        return this.rippleRadius;
    }

    public void setRippleRadius(double rippleRadius) {
        this.rippleRadius.set(rippleRadius);
    }

    public boolean isAnimateBackground() {
        return this.animateBackground.get();
    }

    public StyleableBooleanProperty animateBackgroundProperty() {
        return this.animateBackground;
    }

    public void setAnimateBackground(boolean animateBackground) {
        this.animateBackground.set(animateBackground);
    }

    public Duration getInDuration() {
        return (Duration)this.inDuration.get();
    }

    public ObjectProperty<Duration> inDurationProperty() {
        return this.inDuration;
    }

    public void setInDuration(Duration inDuration) {
        this.inDuration.set((Object)inDuration);
    }

    public Duration getOutDuration() {
        return (Duration)this.outDuration.get();
    }

    public ObjectProperty<Duration> outDurationProperty() {
        return this.outDuration;
    }

    public void setOutDuration(Duration outDuration) {
        this.outDuration.set((Object)outDuration);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getGroupCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return RippleGenerator.getGroupCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<RippleGenerator, Paint> RIPPLE_COLOR;
        private static final CssMetaData<RippleGenerator, Number> RIPPLE_RADIUS;
        private static final CssMetaData<RippleGenerator, Boolean> ANIMATE_BACKGROUND;

        private StyleableProperties() {
        }

        static {
            RIPPLE_COLOR = FACTORY.createPaintCssMetaData("-mfx-ripple-color", RippleGenerator::rippleColorProperty);
            RIPPLE_RADIUS = FACTORY.createSizeCssMetaData("-mfx-ripple-radius", RippleGenerator::rippleRadiusProperty, (Number)10.0);
            ANIMATE_BACKGROUND = FACTORY.createBooleanCssMetaData("-mfx-animate-background", RippleGenerator::animateBackgroundProperty, true);
            cssMetaDataList = List.of(RIPPLE_COLOR, RIPPLE_RADIUS, ANIMATE_BACKGROUND);
        }
    }

    private class Ripple
    extends Circle {
        private final int shadowDelta = 1;
        private final Timeline inAnimation;
        private final Timeline outAnimation;
        private final Timeline shadowAnimation;
        private final SequentialTransition sequentialTransition;
        private final ParallelTransition parallelTransition;

        private Ripple(double centerX, double centerY) {
            super(centerX, centerY, 0.0, (Paint)Color.TRANSPARENT);
            this.shadowDelta = 1;
            this.inAnimation = new Timeline();
            this.outAnimation = new Timeline();
            this.shadowAnimation = new Timeline();
            this.sequentialTransition = new SequentialTransition();
            this.parallelTransition = new ParallelTransition();
            this.setFill((Paint)RippleGenerator.this.rippleColor.get());
            this.setClip((Node)RippleGenerator.this.rippleClipTypeFactory.build(RippleGenerator.this.region));
            this.buildAnimation();
        }

        private void buildAnimation() {
            KeyValue keyValue1 = new KeyValue((WritableValue)this.radiusProperty(), (Object)RippleGenerator.this.rippleRadius.get());
            KeyValue keyValue2 = new KeyValue((WritableValue)this.opacityProperty(), (Object)1.0);
            KeyFrame keyFrame1 = new KeyFrame((Duration)RippleGenerator.this.inDuration.get(), new KeyValue[]{keyValue1});
            KeyFrame keyFrame2 = new KeyFrame((Duration)RippleGenerator.this.inDuration.get(), new KeyValue[]{keyValue2});
            this.inAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{keyFrame1, keyFrame2});
            KeyValue keyValue3 = new KeyValue((WritableValue)this.radiusProperty(), (Object)(RippleGenerator.this.rippleRadius.get() * 2.0));
            KeyValue keyValue4 = new KeyValue((WritableValue)this.opacityProperty(), (Object)0.0);
            KeyFrame keyFrame3 = new KeyFrame((Duration)RippleGenerator.this.outDuration.get(), new KeyValue[]{keyValue3});
            KeyFrame keyFrame4 = new KeyFrame((Duration)RippleGenerator.this.outDuration.get(), new KeyValue[]{keyValue4});
            this.outAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{keyFrame3, keyFrame4});
            if (RippleGenerator.this.level != null) {
                Control control = (Control)RippleGenerator.this.region;
                DropShadow shadowEffect = (DropShadow)((Control)control.getSkin().getSkinnable()).getEffect();
                DropShadow startShadow = MFXDepthManager.shadowOf(RippleGenerator.this.level);
                DropShadow endShadow = MFXDepthManager.shadowOf(RippleGenerator.this.level, 1);
                KeyValue keyValue5 = new KeyValue((WritableValue)shadowEffect.spreadProperty(), (Object)endShadow.getSpread(), Interpolator.LINEAR);
                KeyValue keyValue6 = new KeyValue((WritableValue)shadowEffect.spreadProperty(), (Object)startShadow.getSpread(), Interpolator.LINEAR);
                KeyValue keyValue7 = new KeyValue((WritableValue)shadowEffect.radiusProperty(), (Object)endShadow.getRadius(), Interpolator.LINEAR);
                KeyValue keyValue8 = new KeyValue((WritableValue)shadowEffect.radiusProperty(), (Object)startShadow.getRadius(), Interpolator.LINEAR);
                KeyValue keyValue9 = new KeyValue((WritableValue)shadowEffect.offsetXProperty(), (Object)endShadow.getOffsetX(), Interpolator.LINEAR);
                KeyValue keyValue10 = new KeyValue((WritableValue)shadowEffect.offsetXProperty(), (Object)startShadow.getOffsetX(), Interpolator.LINEAR);
                KeyValue keyValue11 = new KeyValue((WritableValue)shadowEffect.offsetYProperty(), (Object)endShadow.getOffsetY(), Interpolator.LINEAR);
                KeyValue keyValue12 = new KeyValue((WritableValue)shadowEffect.offsetYProperty(), (Object)startShadow.getOffsetY(), Interpolator.LINEAR);
                KeyFrame keyFrame5 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue5, keyValue7, keyValue9, keyValue11});
                KeyFrame keyFrame6 = new KeyFrame((Duration)RippleGenerator.this.inDuration.get(), new KeyValue[]{keyValue6, keyValue8, keyValue10, keyValue12});
                this.shadowAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{keyFrame5, keyFrame6});
                this.parallelTransition.getChildren().add(0, (Object)this.shadowAnimation);
            }
            this.sequentialTransition.getChildren().addAll((Object[])new Animation[]{this.inAnimation, this.outAnimation});
            this.parallelTransition.setInterpolator(MFXAnimationFactory.INTERPOLATOR_V2);
            this.parallelTransition.getChildren().add((Object)this.sequentialTransition);
        }
    }
}

