/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects.ripple.base;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.collections.ObservableStack;
import io.github.palexdev.materialfx.effects.ripple.base.IRipple;
import io.github.palexdev.materialfx.effects.ripple.base.IRippleGenerator;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.shape.Shape;

public abstract class AbstractMFXRippleGenerator<T extends IRipple>
extends Region
implements IRippleGenerator<T> {
    protected final String STYLE_CLASS = "mfx-ripple-generator";
    protected final ObservableStack<Animation> animationsStack;
    protected final Region region;
    protected Supplier<Shape> clipSupplier;
    protected Supplier<T> rippleSupplier;
    protected Function<MouseEvent, PositionBean> positionFunction;
    protected final BooleanProperty animateBackground = new SimpleBooleanProperty(true);
    protected final BooleanProperty animateShadow = new SimpleBooleanProperty(false);
    protected final BooleanProperty checkBounds = new SimpleBooleanProperty(true);
    protected final IntegerProperty depthLevelOffset = new SimpleIntegerProperty(1);
    public final EventHandlerProperty<RippleGeneratorEvent> onAnimationFinished = new EventHandlerProperty<RippleGeneratorEvent>(){

        protected void invalidated() {
            AbstractMFXRippleGenerator.this.setEventHandler(RippleGeneratorEvent.ANIMATION_FINISHED_EVENT, (EventHandler)this.get());
        }
    };

    protected AbstractMFXRippleGenerator(Region region) {
        this.animationsStack = new ObservableStack();
        this.region = region;
    }

    public abstract void generateRipple(MouseEvent var1);

    protected void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"mfx-ripple-generator"});
        this.prefWidthProperty().bind((ObservableValue)this.region.widthProperty());
        this.prefHeightProperty().bind((ObservableValue)this.region.heightProperty());
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.animationsStack.addListener(change -> {
            if (change.getList().isEmpty()) {
                this.fireGeneratorEvent(RippleGeneratorEvent.ANIMATION_FINISHED_EVENT);
            }
        });
    }

    protected boolean isWithinBounds(MouseEvent event) {
        if (event == null) {
            return true;
        }
        double eventX = event.getX();
        double eventY = event.getY();
        Bounds bounds = this.region.getLayoutBounds();
        return bounds.contains(eventX, eventY);
    }

    public boolean isAnimateBackground() {
        return this.animateBackground.get();
    }

    public BooleanProperty animateBackgroundProperty() {
        return this.animateBackground;
    }

    public void setAnimateBackground(boolean animateBackground) {
        this.animateBackground.set(animateBackground);
    }

    public boolean isAnimateShadow() {
        return this.animateShadow.get();
    }

    public BooleanProperty animateShadowProperty() {
        return this.animateShadow;
    }

    public void setAnimateShadow(boolean animateShadow) {
        this.animateShadow.set(animateShadow);
    }

    public boolean isCheckBounds() {
        return this.checkBounds.get();
    }

    public BooleanProperty checkBoundsProperty() {
        return this.checkBounds;
    }

    public void setCheckBounds(boolean checkBounds) {
        this.checkBounds.set(checkBounds);
    }

    public int getDepthLevelOffset() {
        return this.depthLevelOffset.get();
    }

    public IntegerProperty depthLevelOffsetProperty() {
        return this.depthLevelOffset;
    }

    public void setDepthLevelOffset(int depthLevelOffset) {
        this.depthLevelOffset.set(depthLevelOffset);
    }

    public EventHandler<RippleGeneratorEvent> getOnAnimationFinished() {
        return (EventHandler)this.onAnimationFinished.get();
    }

    public EventHandlerProperty<RippleGeneratorEvent> onAnimationFinishedProperty() {
        return this.onAnimationFinished;
    }

    public void setOnAnimationFinished(EventHandler<RippleGeneratorEvent> onAnimationFinished) {
        this.onAnimationFinished.set(onAnimationFinished);
    }

    public void fireGeneratorEvent(EventType<RippleGeneratorEvent> eventType) {
        this.fireEvent(new RippleGeneratorEvent(eventType));
    }

    public static class RippleGeneratorEvent
    extends Event {
        public static final EventType<RippleGeneratorEvent> ANIMATION_FINISHED_EVENT = new EventType(ANY, "ANIMATION_FINISHED_EVENT");

        public RippleGeneratorEvent(EventType<? extends Event> eventType) {
            super(eventType);
        }
    }
}

