/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.factories;

import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;

public class RippleClipTypeFactory {
    private RippleClipType rippleClipType = RippleClipType.NO_CLIP;
    private double radius = 0.0;
    private double arcW = 0.0;
    private double arcH = 0.0;
    private double offsetW = 0.0;
    private double offsetH = 0.0;

    public RippleClipTypeFactory() {
    }

    public RippleClipTypeFactory(RippleClipType rippleClipType) {
        this.rippleClipType = rippleClipType;
    }

    public RippleClipTypeFactory(RippleClipType rippleClipType, double arcW, double arcH) {
        this.rippleClipType = rippleClipType;
        this.arcW = arcW;
        this.arcH = arcH;
    }

    public Shape build(Region region) {
        double w = region.getWidth() + this.offsetW;
        double h = region.getHeight() + this.offsetH;
        switch (this.rippleClipType) {
            case CIRCLE: {
                double radius = this.radius == 0.0 ? Math.sqrt(Math.pow(w, 2.0) + Math.pow(h, 2.0)) / 2.0 : this.radius;
                Circle circle = new Circle(radius);
                circle.setTranslateX(w / 2.0);
                circle.setTranslateY(h / 2.0);
                return circle;
            }
            case RECTANGLE: {
                return new Rectangle(w, h);
            }
            case ROUNDED_RECTANGLE: {
                Rectangle rectangle = new Rectangle(w, h);
                rectangle.setArcWidth(this.arcW);
                rectangle.setArcHeight(this.arcH);
                return rectangle;
            }
        }
        return null;
    }

    public RippleClipTypeFactory setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public RippleClipTypeFactory setArcs(double arcs) {
        this.arcW = arcs;
        this.arcH = arcs;
        return this;
    }

    public RippleClipTypeFactory setArcs(double arcW, double arcH) {
        this.arcW = arcW;
        this.arcH = arcH;
        return this;
    }

    public RippleClipTypeFactory setOffsetW(double offsetW) {
        this.offsetW = offsetW;
        return this;
    }

    public RippleClipTypeFactory setOffsetH(double offsetH) {
        this.offsetH = offsetH;
        return this;
    }

    public RippleClipTypeFactory setRippleClipType(RippleClipType rippleClipType) {
        this.rippleClipType = rippleClipType;
        return this;
    }
}

