/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;
import javafx.util.converter.BooleanStringConverter;

public class BooleanFilter<T>
extends AbstractFilter<T, Boolean> {
    public BooleanFilter(String name, Function<T, Boolean> extractor) {
        this(name, extractor, (StringConverter<Boolean>)new BooleanStringConverter());
    }

    public BooleanFilter(String name, Function<T, Boolean> extractor, StringConverter<Boolean> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<Boolean, Boolean>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Boolean, Boolean>(I18N.getOrDefault("filter.is", new Object[0]), Boolean::equals), new BiPredicateBean<Boolean, Boolean>(I18N.getOrDefault("filter.isNot", new Object[0]), (aBoolean, aBoolean2) -> !aBoolean.equals(aBoolean2))).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final BooleanFilter<T> extend(BiPredicateBean<Boolean, Boolean> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

