/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.EnumStringConverter;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public class EnumFilter<T, E extends Enum<E>>
extends AbstractFilter<T, E> {
    private final Class<E> enumType;

    public EnumFilter(String name, Function<T, E> extractor, Class<E> enumType) {
        this(name, extractor, enumType, new EnumStringConverter<E>(enumType));
    }

    public EnumFilter(String name, Function<T, E> extractor, Class<E> enumType, StringConverter<E> converter) {
        super(name, extractor, converter);
        this.enumType = enumType;
    }

    public Class<E> getEnumType() {
        return this.enumType;
    }

    @Override
    protected ObservableList<BiPredicateBean<E, E>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<Enum, Enum>(I18N.getOrDefault("filter.is", new Object[0]), Enum::equals), new BiPredicateBean<Enum, Enum>(I18N.getOrDefault("filter.isNot", new Object[0]), (anEnum, anEnum2) -> !anEnum.equals(anEnum2))).collect(FXCollectors.toList());
    }

    @Override
    @SafeVarargs
    protected final EnumFilter<T, E> extend(BiPredicateBean<E, E> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

