/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.font;

import io.github.palexdev.materialfx.font.FontHandler;
import io.github.palexdev.materialfx.font.FontResources;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.SimpleStyleableStringProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.css.StyleableStringProperty;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;

public class MFXFontIcon
extends Text {
    private static final StyleablePropertyFactory<MFXFontIcon> FACTORY = new StyleablePropertyFactory(Text.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-font-icon";
    private final StyleableObjectProperty<Color> color = new SimpleStyleableObjectProperty<Color>(StyleableProperties.COLOR, (Object)this, "color", Color.web((String)"#454545")){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableStringProperty description = new SimpleStyleableStringProperty(StyleableProperties.DESCRIPTION, (Object)this, "description"){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.SIZE, (Object)this, "size", 10.0){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };

    public MFXFontIcon() {
        this(null);
    }

    public MFXFontIcon(String description) {
        this(description, 10.0);
    }

    public MFXFontIcon(String description, Color color) {
        this(description, 10.0, color);
    }

    public MFXFontIcon(String description, double size) {
        this(description, size, Color.web((String)"#454545"));
    }

    public MFXFontIcon(String description, double size, Color color) {
        this.initialize();
        this.setDescription(description);
        this.setFont(Font.font((String)this.getFont().getFamily(), (double)size));
        this.setColor(color);
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-font-icon");
        this.setFont(FontHandler.getResources());
        this.setFontSmoothingType(FontSmoothingType.GRAY);
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String desc = this.getDescription();
            return desc != null && !desc.isBlank() ? this.descriptionToString(desc) : "";
        }, (Observable[])new Observable[]{this.description}));
        this.fillProperty().bind(this.colorProperty());
        this.sizeProperty().addListener((observable, oldValue, newValue) -> this.setFontSize(newValue.doubleValue()));
    }

    private String descriptionToString(String desc) {
        return String.valueOf(FontHandler.getCode(desc));
    }

    private void setFontSize(double size) {
        String fontFamily = this.getFont().getFamily();
        this.setFont(Font.font((String)fontFamily, (double)size));
    }

    public static MFXFontIcon getRandomIcon(double size, Color color) {
        FontResources[] resources = FontResources.values();
        int random = (int)(Math.random() * (double)resources.length);
        String desc = resources[random].getDescription();
        return new MFXFontIcon(desc, size, color);
    }

    public Color getColor() {
        return (Color)this.color.get();
    }

    public StyleableObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color.set((Object)color);
    }

    public String getDescription() {
        return this.description.get();
    }

    public StyleableStringProperty descriptionProperty() {
        return this.description;
    }

    public void setDescription(String code) {
        this.description.set(code);
    }

    public double getSize() {
        return this.size.get();
    }

    public StyleableDoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double size) {
        this.size.set(size);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return MFXFontIcon.getClassCssMetaDataList();
    }

    public static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXFontIcon, Color> COLOR;
        private static final CssMetaData<MFXFontIcon, String> DESCRIPTION;
        private static final CssMetaData<MFXFontIcon, Number> SIZE;

        static {
            COLOR = FACTORY.createColorCssMetaData("-mfx-color", MFXFontIcon::colorProperty, Color.web((String)"#454545"));
            DESCRIPTION = FACTORY.createStringCssMetaData("-mfx-description", MFXFontIcon::descriptionProperty);
            SIZE = FACTORY.createSizeCssMetaData("-mfx-size", MFXFontIcon::sizeProperty, (Number)10);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Text.getClassCssMetaData(), COLOR, DESCRIPTION, SIZE);
        }
    }
}

