/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.layout;

import io.github.palexdev.materialfx.enums.ScaleBehavior;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

public class ScalableContentPane
extends Region {
    private final ObjectProperty<Node> content = new SimpleObjectProperty();
    private final DoubleProperty minScaleX = new SimpleDoubleProperty(Double.MIN_VALUE);
    private final DoubleProperty maxScaleX = new SimpleDoubleProperty(Double.MAX_VALUE);
    private final DoubleProperty minScaleY = new SimpleDoubleProperty(Double.MIN_VALUE);
    private final DoubleProperty maxScaleY = new SimpleDoubleProperty(Double.MAX_VALUE);
    private final BooleanProperty fitToWidth = new SimpleBooleanProperty(true);
    private final BooleanProperty fitToHeight = new SimpleBooleanProperty(true);
    private final ObjectProperty<ScaleBehavior> scaleBehavior = new SimpleObjectProperty((Object)ScaleBehavior.ALWAYS);
    private Scale scale;
    private double scaleWidth;
    private double scaleHeight;
    private boolean aspectScale = true;
    private boolean autoRescale = true;
    private boolean manualReset;

    public ScalableContentPane() {
        this((Node)new Pane());
    }

    public ScalableContentPane(Node content) {
        this.initialize();
        this.setContent(content);
    }

    private void initialize() {
        this.needsLayoutProperty().addListener((observable, oldValue, newValue) -> {
            boolean prefHCondition;
            boolean wCondition = this.getWidth() <= this.getPrefWidth();
            boolean hCondition = this.getHeight() <= this.getPrefHeight();
            boolean prefWCondition = this.getPrefWidth() == -1.0;
            boolean bl = prefHCondition = this.getPrefHeight() == -1.0;
            if (newValue.booleanValue() && (wCondition || hCondition) || prefWCondition || prefHCondition) {
                this.computeScale();
            }
        });
        this.fitToWidth.addListener((observable, oldValue, newValue) -> this.requestLayout());
        this.fitToHeight.addListener((observable, oldValue, newValue) -> this.requestLayout());
        this.scaleBehavior.addListener((observable, oldValue, newValue) -> this.requestLayout());
        this.content.addListener((observable, oldValue, newValue) -> this.initializeContent());
    }

    private void initializeContent() {
        ChangeListener boundsListener = (observable, oldValue, newValue) -> {
            if (this.isAutoRescale()) {
                Node cnt = this.getContent();
                if (cnt instanceof Region) {
                    Region rgn = (Region)cnt;
                    rgn.requestLayout();
                }
                this.requestLayout();
                this.setNeedsLayout(false);
            }
        };
        ChangeListener layoutListener = (observable, oldValue, newValue) -> {
            if (this.isAutoRescale()) {
                Node cnt = this.getContent();
                if (cnt instanceof Parent) {
                    Parent prt = (Parent)cnt;
                    prt.requestLayout();
                }
                this.requestLayout();
                this.setNeedsLayout(false);
            }
        };
        Node content = this.getContent();
        if (this.getContent() instanceof Pane) {
            Pane pane = (Pane)content;
            ListChangeListener childrenListener = c -> {
                while (c.next()) {
                    if (c.wasRemoved()) {
                        for (Node node : c.getRemoved()) {
                            node.boundsInLocalProperty().removeListener(boundsListener);
                            node.layoutXProperty().removeListener(layoutListener);
                            node.layoutYProperty().removeListener(layoutListener);
                        }
                        continue;
                    }
                    if (!c.wasAdded()) continue;
                    for (Node node : c.getAddedSubList()) {
                        node.boundsInLocalProperty().addListener(boundsListener);
                        node.layoutXProperty().addListener(layoutListener);
                        node.layoutYProperty().addListener(layoutListener);
                    }
                }
            };
            pane.getChildren().addListener(childrenListener);
        }
        this.scale = Transform.scale((double)1.0, (double)1.0, (double)0.0, (double)0.0);
        content.getTransforms().add((Object)this.scale);
        this.getChildren().add((Object)content);
        ChangeListener scaleListener = (observable, oldValue, newValue) -> this.requestScale();
        this.scale.setOnTransformChanged(event -> {
            this.requestLayout();
            this.setNeedsLayout(false);
        });
        this.minScaleX.addListener(scaleListener);
        this.minScaleY.addListener(scaleListener);
        this.maxScaleX.addListener(scaleListener);
        this.maxScaleY.addListener(scaleListener);
    }

    private void computeScale() {
        double realWidth = this.getContent().prefWidth(this.getLayoutBounds().getHeight());
        double realHeight = this.getContent().prefHeight(this.getLayoutBounds().getWidth());
        double leftAndRight = this.getInsets().getLeft() + this.getInsets().getRight();
        double topAndBottom = this.getInsets().getTop() + this.getInsets().getBottom();
        double contentWidth = this.getLayoutBounds().getWidth() - leftAndRight;
        double contentHeight = this.getLayoutBounds().getHeight() - topAndBottom;
        this.scaleWidth = contentWidth / realWidth;
        this.scaleHeight = contentHeight / realHeight;
        this.scaleWidth = Math.max(this.scaleWidth, this.getMinScaleX());
        this.scaleWidth = Math.min(this.scaleWidth, this.getMaxScaleX());
        this.scaleHeight = Math.max(this.scaleHeight, this.getMinScaleY());
        this.scaleHeight = Math.min(this.scaleHeight, this.getMaxScaleY());
        if (this.isAspectScale()) {
            double scaleValue = Math.min(this.scaleWidth, this.scaleHeight);
            if (this.getScaleBehavior() == ScaleBehavior.ALWAYS || this.manualReset) {
                this.scale.setX(scaleValue);
                this.scale.setY(scaleValue);
            } else if (this.getScaleBehavior() == ScaleBehavior.IF_NECESSARY && scaleValue < this.scale.getX() && this.getLayoutBounds().getWidth() > 0.0) {
                this.scale.setX(scaleValue);
                this.scale.setY(scaleValue);
            }
        } else if (this.getScaleBehavior() == ScaleBehavior.ALWAYS || this.manualReset) {
            this.scale.setX(this.scaleWidth);
            this.scale.setY(this.scaleHeight);
        } else if (this.getScaleBehavior() == ScaleBehavior.IF_NECESSARY) {
            if (this.scaleWidth < this.scale.getX() && this.getLayoutBounds().getWidth() > 0.0) {
                this.scale.setX(this.scaleWidth);
            }
            if (this.scaleHeight < this.scale.getY() && this.getLayoutBounds().getHeight() > 0.0) {
                this.scale.setY(this.scaleHeight);
            }
        }
        double resizeScaleW = this.scale.getX();
        double resizeScaleH = this.scale.getY();
        this.getContent().relocate(this.getInsets().getLeft(), this.getInsets().getTop());
        double realContentWidth = this.isFitToWidth() ? contentWidth / resizeScaleW : contentWidth / this.scaleWidth;
        double realContentHeight = this.isFitToHeight() ? contentHeight / resizeScaleH : contentHeight / this.scaleHeight;
        this.getContent().resize(realContentWidth, realContentHeight);
    }

    public void requestScale() {
        this.computeScale();
    }

    public void resetScale() {
        if (this.manualReset) {
            return;
        }
        this.manualReset = true;
        try {
            this.computeScale();
        }
        finally {
            this.manualReset = false;
        }
    }

    protected double computeMinWidth(double height) {
        double result = this.getInsets().getLeft() + this.getInsets().getRight();
        return result += this.getContent().prefWidth(height) * this.getMinScaleX();
    }

    protected double computeMinHeight(double width) {
        double result = this.getInsets().getTop() + this.getInsets().getBottom();
        return result += this.getContent().prefHeight(width) * this.getMinScaleY();
    }

    protected double computePrefWidth(double height) {
        double result = this.getInsets().getLeft() + this.getInsets().getRight();
        return result += this.getContent().prefWidth(height) * this.scaleWidth;
    }

    protected double computePrefHeight(double width) {
        double result = this.getInsets().getTop() + this.getInsets().getBottom();
        return result += this.getContent().prefHeight(width) * this.scaleHeight;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.computeScale();
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public double getMinScaleX() {
        return this.minScaleX.get();
    }

    public DoubleProperty minScaleXProperty() {
        return this.minScaleX;
    }

    public void setMinScaleX(double minScaleX) {
        this.minScaleX.set(minScaleX);
    }

    public double getMaxScaleX() {
        return this.maxScaleX.get();
    }

    public DoubleProperty maxScaleXProperty() {
        return this.maxScaleX;
    }

    public void setMaxScaleX(double maxScaleX) {
        this.maxScaleX.set(maxScaleX);
    }

    public double getMinScaleY() {
        return this.minScaleY.get();
    }

    public DoubleProperty minScaleYProperty() {
        return this.minScaleY;
    }

    public void setMinScaleY(double minScaleY) {
        this.minScaleY.set(minScaleY);
    }

    public double getMaxScaleY() {
        return this.maxScaleY.get();
    }

    public DoubleProperty maxScaleYProperty() {
        return this.maxScaleY;
    }

    public void setMaxScaleY(double maxScaleY) {
        this.maxScaleY.set(maxScaleY);
    }

    public boolean isFitToWidth() {
        return this.fitToWidth.get();
    }

    public BooleanProperty fitToWidthProperty() {
        return this.fitToWidth;
    }

    public void setFitToWidth(boolean fitToWidth) {
        this.fitToWidth.set(fitToWidth);
    }

    public boolean isFitToHeight() {
        return this.fitToHeight.get();
    }

    public BooleanProperty fitToHeightProperty() {
        return this.fitToHeight;
    }

    public void setFitToHeight(boolean fitToHeight) {
        this.fitToHeight.set(fitToHeight);
    }

    public ScaleBehavior getScaleBehavior() {
        return (ScaleBehavior)((Object)this.scaleBehavior.get());
    }

    public ObjectProperty<ScaleBehavior> scaleBehaviorProperty() {
        return this.scaleBehavior;
    }

    public void setScaleBehavior(ScaleBehavior scaleBehavior) {
        this.scaleBehavior.set((Object)scaleBehavior);
    }

    public Scale getScale() {
        return this.scale;
    }

    public boolean isAspectScale() {
        return this.aspectScale;
    }

    public void setAspectScale(boolean aspectScale) {
        this.aspectScale = aspectScale;
    }

    public boolean isAutoRescale() {
        return this.autoRescale;
    }

    public void setAutoRescale(boolean autoRescale) {
        this.autoRescale = autoRescale;
    }
}

